"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridEmbeddable = DiscoverGridEmbeddable;
exports.DiscoverGridMemoized = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _discover_grid = require("../../components/discover_grid");
var _discover_grid_flyout = require("../../components/discover_grid_flyout");
var _saved_search_embeddable_base = require("./saved_search_embeddable_base");
var _total_documents = require("../../application/main/components/total_documents/total_documents");
var _context_awareness = require("../../context_awareness");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/embeddable/components/saved_search_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiscoverGridMemoized = exports.DiscoverGridMemoized = /*#__PURE__*/_react.default.memo(_discover_grid.DiscoverGrid);
function DiscoverGridEmbeddable(props) {
  const {
    interceptedWarnings,
    enableDocumentViewer,
    ...gridProps
  } = props;
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const [initialTabId, setInitialTabId] = (0, _react.useState)(undefined);
  const docViewerRef = (0, _react.useRef)(null);
  const setExpandedDocWithInitialTab = (0, _react.useCallback)((doc, options) => {
    setExpandedDoc(doc);
    setInitialTabId(options === null || options === void 0 ? void 0 : options.initialTabId);
    if (options !== null && options !== void 0 && options.initialTabId) {
      var _docViewerRef$current;
      (_docViewerRef$current = docViewerRef.current) === null || _docViewerRef$current === void 0 ? void 0 : _docViewerRef$current.setSelectedTabId(options.initialTabId);
    }
  }, []);
  const renderDocumentView = (0, _react.useCallback)((hit, displayedRows, displayedColumns, customColumnsMeta) => /*#__PURE__*/_react.default.createElement(_discover_grid_flyout.DiscoverGridFlyout, {
    dataView: props.dataView,
    hit: hit,
    hits: displayedRows
    // if default columns are used, dont make them part of the URL - the context state handling will take care to restore them
    ,
    columns: displayedColumns,
    columnsMeta: customColumnsMeta,
    savedSearchId: props.savedSearchId,
    onFilter: props.onFilter,
    onRemoveColumn: props.onRemoveColumn,
    onAddColumn: props.onAddColumn,
    onClose: () => setExpandedDoc(undefined),
    setExpandedDoc: setExpandedDocWithInitialTab,
    initialTabId: initialTabId,
    query: props.query,
    filters: props.filters,
    docViewerRef: docViewerRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), [props.dataView, props.savedSearchId, props.onFilter, props.onRemoveColumn, props.onAddColumn, props.query, props.filters, setExpandedDocWithInitialTab, initialTabId]);
  const renderCustomToolbarWithElements = (0, _react.useMemo)(() => (0, _unifiedDataTable.getRenderCustomToolbarWithElements)({
    leftSide: typeof props.totalHitCount === 'number' ? /*#__PURE__*/_react.default.createElement(_total_documents.TotalDocuments, {
      totalHitCount: props.totalHitCount,
      isEsqlMode: props.isPlainRecord,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }) : undefined
  }), [props.totalHitCount, props.isPlainRecord]);
  const getCellRenderersAccessor = (0, _context_awareness.useProfileAccessor)('getCellRenderers');
  const cellRenderers = (0, _react.useMemo)(() => {
    var _gridProps$dataGridDe;
    const getCellRenderers = getCellRenderersAccessor(() => ({}));
    return getCellRenderers({
      actions: {
        addFilter: props.onFilter
      },
      dataView: props.dataView,
      density: (_gridProps$dataGridDe = gridProps.dataGridDensityState) !== null && _gridProps$dataGridDe !== void 0 ? _gridProps$dataGridDe : (0, _unifiedDataTable.getDataGridDensity)(props.services.storage, 'discover'),
      rowHeight: (0, _unifiedDataTable.getRowHeight)({
        storage: props.services.storage,
        consumer: 'discover',
        rowHeightState: gridProps.rowHeightState,
        configRowHeight: props.configRowHeight
      })
    });
  }, [getCellRenderersAccessor, props.onFilter, props.dataView, props.services.storage, props.configRowHeight, gridProps.dataGridDensityState, gridProps.rowHeightState]);
  return /*#__PURE__*/_react.default.createElement(_saved_search_embeddable_base.SavedSearchEmbeddableBase, {
    totalHitCount: undefined // it will be rendered inside the custom grid toolbar instead
    ,
    isLoading: props.loadingState === _unifiedDataTable.DataLoadingState.loading,
    dataTestSubj: "embeddedSavedSearchDocTable",
    interceptedWarnings: props.interceptedWarnings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DiscoverGridMemoized, (0, _extends2.default)({}, gridProps, {
    isPaginationEnabled: !gridProps.isPlainRecord,
    totalHits: props.totalHitCount,
    setExpandedDoc: setExpandedDocWithInitialTab,
    expandedDoc: expandedDoc,
    showMultiFields: props.services.uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    maxDocFieldsDisplayed: props.services.uiSettings.get(_discoverUtils.MAX_DOC_FIELDS_DISPLAYED),
    renderDocumentView: enableDocumentViewer ? renderDocumentView : undefined,
    renderCustomToolbar: renderCustomToolbarWithElements,
    externalCustomRenderers: cellRenderers,
    enableComparisonMode: true,
    showColumnTokens: true,
    showFullScreenButton: false,
    className: "unifiedDataTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  })));
}