"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionType = exports.RootProfileService = void 0;
var _profile_service = require("../profile_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Indicates the current solution type (i.e. Observability, Security, Search)
 */
let SolutionType = exports.SolutionType = /*#__PURE__*/function (SolutionType) {
  SolutionType["Observability"] = "oblt";
  SolutionType["Security"] = "security";
  SolutionType["Search"] = "es";
  SolutionType["Default"] = "default";
  return SolutionType;
}({});
/**
 * The root profile interface
 */
/**
 * Parameters for the root profile provider `resolve` method
 */
/**
 * The resulting context object returned by the root profile provider `resolve` method
 */
class RootProfileService extends _profile_service.AsyncProfileService {
  constructor() {
    super({
      profileId: 'default-root-profile',
      solutionType: SolutionType.Default
    });
  }
}
exports.RootProfileService = RootProfileService;