"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProfileProviderSharedServices = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Dependencies required by profile provider implementations
 */

/**
 * Shared services provided to profile provider implementations
 */

/**
 * Services provided to profile provider implementations
 */

/**
 * Creates the profile provider services
 * @param _deps Profile provider dependencies
 * @returns Profile provider services
 */
const createProfileProviderSharedServices = async ({
  logsDataAccess,
  apmSourcesAccess,
  metricsExperience
}) => {
  const [logsContextService, apmContextService, metricsContextService] = await Promise.all([(0, _discoverUtils.createLogsContextService)({
    logsDataAccess
  }), (0, _discoverUtils.createApmContextService)({
    apmSourcesAccess
  }), (0, _discoverUtils.createMetricsContextService)({
    metricsExperience
  })]);
  return {
    logsContextService,
    apmContextService,
    metricsContextService
  };
};
exports.createProfileProviderSharedServices = createProfileProviderSharedServices;