"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changeDataView = changeDataView;
var _discoverUtils = require("@kbn/discover-utils");
var _add_log = require("../../../../utils/add_log");
var _get_switch_data_view_app_state = require("./get_switch_data_view_app_state");
var _redux = require("../redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Function executed when switching data view in the UI
 */
async function changeDataView({
  dataViewId,
  services,
  internalState,
  runtimeStateManager,
  injectCurrentTab,
  getCurrentTab
}) {
  (0, _add_log.addLog)('[ui] changeDataView', {
    id: dataViewId
  });
  const {
    dataViews,
    uiSettings
  } = services;
  const {
    currentDataView$
  } = (0, _redux.selectTabRuntimeState)(runtimeStateManager, getCurrentTab().id);
  const currentDataView = currentDataView$.getValue();
  let nextDataView = null;
  internalState.dispatch(injectCurrentTab(_redux.internalStateActions.setIsDataViewLoading)({
    isDataViewLoading: true
  }));
  try {
    nextDataView = typeof dataViewId === 'string' ? await dataViews.get(dataViewId, false) : dataViewId;

    // If nextDataView is an ad hoc data view with no fields, refresh its field list.
    // This can happen when default profile data views are created without fields
    // to avoid unnecessary requests on startup.
    if (!nextDataView.isPersisted() && !nextDataView.fields.length) {
      await dataViews.refreshFields(nextDataView);
    }
  } catch (e) {
    // Swallow the error and keep the current data view
  }
  if (nextDataView && currentDataView) {
    // Reset the default profile state if we are switching to a different data view
    internalState.dispatch(injectCurrentTab(_redux.internalStateActions.setResetDefaultProfileState)({
      resetDefaultProfileState: {
        columns: true,
        rowHeight: true,
        breakdownField: true,
        hideChart: true
      }
    }));
    const currentAppState = getCurrentTab().appState;
    const nextAppState = (0, _get_switch_data_view_app_state.getDataViewAppState)(currentDataView, nextDataView, uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING, []), currentAppState.columns || [], currentAppState.sort || [], uiSettings.get(_discoverUtils.MODIFY_COLUMNS_ON_SWITCH), uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING), currentAppState.query);
    internalState.dispatch(injectCurrentTab(_redux.internalStateActions.updateAppState)({
      appState: nextAppState
    }));
    if (internalState.getState().expandedDoc) {
      internalState.dispatch(_redux.internalStateActions.setExpandedDoc({
        expandedDoc: undefined
      }));
    }
  }
  internalState.dispatch(injectCurrentTab(_redux.internalStateActions.setIsDataViewLoading)({
    isDataViewLoading: false
  }));
}