"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateManagers = void 0;
var _react = require("react");
var _redux = require("../redux");
var _tabs_storage_manager = require("../tabs_storage_manager");
var _discover_search_session = require("../discover_search_session");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useStateManagers = ({
  services,
  urlStateStorage,
  customizationContext
}) => {
  const tabsEnabled = services.discoverFeatureFlags.getTabsEnabled();

  // syncing with the _tab part URL
  const [tabsStorageManager] = (0, _react.useState)(() => (0, _tabs_storage_manager.createTabsStorageManager)({
    urlStateStorage,
    storage: services.storage,
    enabled: tabsEnabled
  }));
  const [runtimeStateManager] = (0, _react.useState)(() => (0, _redux.createRuntimeStateManager)());
  const [searchSessionManager] = (0, _react.useState)(() => {
    return new _discover_search_session.DiscoverSearchSessionManager({
      history: services.history,
      session: services.data.search.session
    });
  });
  const [internalState] = (0, _react.useState)(() => (0, _redux.createInternalStateStore)({
    services,
    customizationContext,
    runtimeStateManager,
    urlStateStorage,
    tabsStorageManager,
    searchSessionManager
  }));
  (0, _react.useEffect)(() => {
    const stopUrlSync = tabsStorageManager.startUrlSync({
      // if `_tab` in URL changes (for example via browser history), try to restore the previous state
      onChanged: urlState => {
        const {
          tabId: restoreTabId
        } = urlState;
        if (restoreTabId) {
          internalState.dispatch(_redux.internalStateActions.restoreTab({
            restoreTabId
          }));
        }
      }
    });
    return () => {
      stopUrlSync();
    };
  }, [tabsStorageManager, internalState]);
  return (0, _react.useMemo)(() => ({
    internalState,
    runtimeStateManager,
    searchSessionManager
  }), [internalState, runtimeStateManager, searchSessionManager]);
};
exports.useStateManagers = useStateManagers;