"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetQualityESClient = createDatasetQualityESClient;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDatasetQualityESClient(esClient) {
  return {
    search(searchParams) {
      return esClient.search({
        ...searchParams
      });
    },
    msearch(index = {}, searches) {
      return esClient.msearch({
        searches: searches.map(search => [index, search]).flat()
      });
    },
    fieldCaps(params) {
      return esClient.fieldCaps({
        ignore_unavailable: true,
        allow_no_indices: true,
        expand_wildcards: ['open', 'hidden'],
        ...params
      });
    },
    mappings(params) {
      return esClient.indices.getMapping(params);
    },
    settings(params) {
      return esClient.indices.getSettings(params);
    },
    updateComponentTemplate(params) {
      return esClient.cluster.putComponentTemplate(params);
    },
    updateSettings(params) {
      return esClient.indices.putSettings(params);
    },
    rollover(params) {
      return esClient.indices.rollover(params);
    },
    indexTemplates(params) {
      return esClient.indices.getIndexTemplate(params);
    }
  };
}