"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPreview = ChartPreview;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _alertingComparators = require("@kbn/alerting-comparators");
var _chartsTheme = require("@kbn/charts-theme");
var _public = require("@kbn/data-plugin/public");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _chart_preview_helper = require("./chart_preview_helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/rule_types/degraded_docs/rule_form/chart_preview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getTimeZone(uiSettings) {
  const kibanaTimeZone = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_public.UI_SETTINGS.DATEFORMAT_TZ);
  if (!kibanaTimeZone || kibanaTimeZone === 'Browser') {
    return _moment.default.tz.guess();
  }
  return kibanaTimeZone;
}
function ChartPreview({
  yTickFormat,
  threshold,
  comparator,
  uiSettings,
  series,
  timeSize = 5,
  timeUnit = 'm',
  totalGroups
}) {
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const DEFAULT_DATE_FORMAT = 'Y-MM-DD HH:mm:ss';
  const barSeries = (0, _react.useMemo)(() => {
    return series.flatMap(serie => serie.data.map(point => ({
      ...point,
      groupBy: serie.name
    })));
  }, [series]);
  const timeZone = getTimeZone(uiSettings);
  const chartSize = 120;
  const {
    yMax,
    xMin,
    xMax
  } = (0, _chart_preview_helper.getDomain)(series);
  const chartDomain = {
    max: Math.max(yMax === 0 ? 1 : yMax, Math.max(...threshold)) * 1.1,
    // Add 10% headroom.
    min: 0
  };
  const dateFormatter = (0, _react.useMemo)(() => (0, _charts.niceTimeFormatter)([xMin, xMax]), [xMin, xMax]);
  const theme = (0, _eui.useEuiTheme)();
  const thresholdOpacity = 0.1;
  const [sortedThreshold, setSortedThreshold] = (0, _react.useState)(threshold);
  (0, _react.useEffect)(() => {
    setSortedThreshold([...threshold].sort((a, b) => a - b));
  }, [threshold]);
  const style = {
    fill: theme.euiTheme.colors.danger,
    line: {
      strokeWidth: 1,
      stroke: theme.euiTheme.colors.danger,
      opacity: 1
    },
    opacity: thresholdOpacity
  };
  const rectThresholdToMax = value => [{
    coordinates: {
      x0: xMin,
      x1: xMax,
      y0: value,
      y1: chartDomain.max
    }
  }];
  const rectThresholdToMin = value => [{
    coordinates: {
      x0: xMin,
      x1: xMax,
      y0: chartDomain.min,
      y1: value
    }
  }];
  const rectThresholdToThreshold = [{
    coordinates: {
      x0: xMin,
      x1: xMax,
      y0: sortedThreshold[0],
      y1: sortedThreshold[1]
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: chartSize
    },
    "data-test-subj": "ChartPreview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => {
      const dateFormat = uiSettings && uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT) || DEFAULT_DATE_FORMAT;
      return (0, _moment.default)(value).format(dateFormat);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    locale: _i18n.i18n.getLocale(),
    baseTheme: baseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    dataValues: [{
      dataValue: sortedThreshold[0]
    }],
    domainType: _charts.AnnotationDomainType.YDomain,
    id: "chart_preview_line_annotation",
    markerPosition: "left",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }), comparator !== _alertingComparators.COMPARATORS.BETWEEN && /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: comparator === _alertingComparators.COMPARATORS.GREATER_THAN || comparator === _alertingComparators.COMPARATORS.GREATER_THAN_OR_EQUALS ? rectThresholdToMax(sortedThreshold[0]) : rectThresholdToMin(sortedThreshold[0]),
    hideTooltips: true,
    id: "chart_preview_rect_annotation",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), threshold.length > 1 && [_alertingComparators.COMPARATORS.NOT_BETWEEN, _alertingComparators.COMPARATORS.BETWEEN].includes(comparator) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    dataValues: [{
      dataValue: sortedThreshold[1]
    }],
    domainType: _charts.AnnotationDomainType.YDomain,
    id: "chart_preview_line_annotation_2",
    markerPosition: "left",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: comparator === _alertingComparators.COMPARATORS.NOT_BETWEEN ? rectThresholdToMax(sortedThreshold[1]) : rectThresholdToThreshold,
    hideTooltips: true,
    id: "chart_preview_rect_annotation_2",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_x_axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_y_axis",
    position: _charts.Position.Left,
    tickFormat: yTickFormat,
    ticks: 5,
    domain: chartDomain,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "chart_preview_bar_series",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    splitSeriesAccessors: ['groupBy'],
    data: barSeries,
    barSeriesStyle: {
      rectBorder: {
        strokeWidth: 1,
        visible: true
      },
      rect: {
        opacity: 1
      }
    },
    timeZone: timeZone,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  })), series.length > 0 && /*#__PURE__*/_react.default.createElement(_chart_preview_helper.TimeLabelForData, {
    field: '@timestamp',
    timeSize: timeSize,
    timeUnit: timeUnit,
    series: series.length,
    totalGroups: totalGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }));
}