"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFailureStoreModal = useFailureStoreModal;
var _react = _interopRequireWildcard(require("react"));
var _failureStoreModal = require("@kbn/failure-store-modal");
var _streamsSchema = require("@kbn/streams-schema");
var _i18n = require("@kbn/i18n");
var _use_dataset_quality_details_state = require("./use_dataset_quality_details_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFailureStoreModal() {
  const {
    canUserReadFailureStore,
    hasFailureStore,
    defaultRetentionPeriod,
    customRetentionPeriod,
    updateFailureStore,
    canUserManageFailureStore,
    streamDefinition,
    view,
    dataStreamDetails
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const [isFailureStoreModalOpen, setIsFailureStoreModalOpen] = (0, _react.useState)(false);
  const openModal = () => {
    setIsFailureStoreModalOpen(true);
  };
  const closeModal = () => {
    setIsFailureStoreModalOpen(false);
  };
  const getFailureStoreConfigForStreamView = data => {
    if ('inherit' in data && data.inherit) {
      return {
        inherit: {}
      };
    } else if (!data.failureStoreEnabled) {
      return {
        disabled: {}
      };
    } else if ('retentionDisabled' in data && data.retentionDisabled) {
      return {
        lifecycle: {
          disabled: {}
        }
      };
    } else {
      return {
        lifecycle: {
          enabled: {
            data_retention: 'customRetentionPeriod' in data ? data.customRetentionPeriod : undefined
          }
        }
      };
    }
  };
  const renderModalForStreamView = () => {
    var _dataStreamDetails$is;
    if (!streamDefinition) {
      return null;
    }
    const isWired = view === 'wired';
    const canShowInherit = !(0, _streamsSchema.isRootStreamDefinition)(streamDefinition.stream);
    const failureStore = streamDefinition.stream.ingest.failure_store;
    const isCurrentlyInherited = (0, _streamsSchema.isInheritFailureStore)(failureStore);
    const effectiveFailureStoreEnabled = (0, _streamsSchema.isEnabledFailureStore)(failureStore);
    const retentionDisabled = (0, _streamsSchema.isDisabledLifecycleFailureStore)(failureStore);
    const effectiveCustomRetentionPeriod = (0, _streamsSchema.isEnabledLifecycleFailureStore)(failureStore) ? failureStore.lifecycle.enabled.data_retention : undefined;
    const isServerless = (_dataStreamDetails$is = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.isServerless) !== null && _dataStreamDetails$is !== void 0 ? _dataStreamDetails$is : false;
    return /*#__PURE__*/_react.default.createElement(_failureStoreModal.FailureStoreModal, {
      onCloseModal: closeModal,
      onSaveModal: handleSaveModal,
      failureStoreProps: {
        failureStoreEnabled: effectiveFailureStoreEnabled,
        defaultRetentionPeriod,
        customRetentionPeriod: effectiveCustomRetentionPeriod,
        retentionDisabled
      },
      ...(canShowInherit && {
        inheritOptions: {
          canShowInherit,
          isWired,
          isCurrentlyInherited
        }
      }),
      showIlmDescription: !isServerless,
      canShowDisableLifecycle: !isServerless,
      disableButtonLabel: _i18n.i18n.translate('xpack.datasetQuality.failureStoreModal.indefiniteButtonLabel', {
        defaultMessage: 'Indefinite'
      })
    });
  };
  const handleSaveModal = async data => {
    var _data$failureStoreEna;
    const newFailureStoreConfig = view === 'dataQuality' ? {
      failureStoreDataQualityConfig: {
        failureStoreEnabled: (_data$failureStoreEna = data.failureStoreEnabled) !== null && _data$failureStoreEna !== void 0 ? _data$failureStoreEna : false,
        customRetentionPeriod: 'customRetentionPeriod' in data ? data.customRetentionPeriod : undefined
      }
    } : {
      failureStoreStreamConfig: getFailureStoreConfigForStreamView(data)
    };
    updateFailureStore(newFailureStoreConfig);
    closeModal();
  };
  const renderModal = () => {
    if (!canUserManageFailureStore || !isFailureStoreModalOpen) {
      return null;
    }
    if (view === 'dataQuality') {
      return /*#__PURE__*/_react.default.createElement(_failureStoreModal.FailureStoreModal, {
        onCloseModal: closeModal,
        onSaveModal: handleSaveModal,
        failureStoreProps: {
          failureStoreEnabled: hasFailureStore,
          defaultRetentionPeriod,
          customRetentionPeriod
        }
      });
    }
    // For stream views (classic/wired)
    return renderModalForStreamView();
  };
  return {
    isFailureStoreModalOpen,
    openModal,
    closeModal,
    handleSaveModal,
    canUserReadFailureStore,
    canUserManageFailureStore,
    hasFailureStore,
    defaultRetentionPeriod,
    customRetentionPeriod,
    renderModal
  };
}