"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQualityIssuesColumns = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _translations = require("../../../../../common/translations");
var _spark_plot = require("../../../common/spark_plot");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/quality_issues/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const expandDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssuesTable.expand', {
  defaultMessage: 'Expand'
});
const collapseDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssuesTable.collapseLabel', {
  defaultMessage: 'Collapse'
});
const getQualityIssuesColumns = ({
  dateFormatter,
  isLoading,
  expandedQualityIssue,
  openQualityIssueFlyout
}) => [{
  name: '',
  field: 'name',
  render: (_, {
    name,
    type
  }) => {
    const isExpanded = name === (expandedQualityIssue === null || expandedQualityIssue === void 0 ? void 0 : expandedQualityIssue.name) && type === (expandedQualityIssue === null || expandedQualityIssue === void 0 ? void 0 : expandedQualityIssue.type);
    const onExpandClick = () => {
      openQualityIssueFlyout(name, type);
    };
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "datasetQualityDetailsQualityIssuesExpandButton",
      size: "xs",
      color: "text",
      onClick: onExpandClick,
      iconType: isExpanded ? 'minimize' : 'expand',
      title: !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel,
      "aria-label": !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    });
  },
  width: '40px',
  css: (0, _react.css)`
      &.euiTableCellContent {
        padding: 0;
      }
    `
}, {
  name: _translations.fieldColumnName,
  field: 'name',
  render: (_, {
    name,
    type
  }) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, type === 'degraded' ? name : _translations.overviewPanelDatasetQualityIndicatorFailedDocs);
  }
}, {
  name: _translations.issueColumnName,
  field: 'name',
  render: (_, {
    type
  }) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, type === 'degraded' ? _translations.degradedField : _translations.documentIndexFailed);
  }
}, {
  name: _translations.documentsColumnName,
  field: 'count',
  align: 'left',
  render: (_, {
    count,
    timeSeries
  }) => {
    const countValue = (0, _eui.formatNumber)(count, _constants.NUMBER_FORMAT);
    return /*#__PURE__*/_react2.default.createElement(_spark_plot.SparkPlot, {
      series: timeSeries,
      valueLabel: countValue,
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 14
      }
    });
  }
}, {
  name: _translations.lastOccurrenceColumnName,
  sortable: true,
  field: 'lastOccurrence',
  render: lastOccurrence => {
    return dateFormatter.convert(lastOccurrence);
  }
}];
exports.getQualityIssuesColumns = getQualityIssuesColumns;