"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnappedSingleBrushWindowParameters = exports.getSingleBrushWindowParameters = exports.SingleBrush = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var d3Brush = _interopRequireWildcard(require("d3-brush"));
var d3Scale = _interopRequireWildcard(require("d3-scale"));
var d3Selection = _interopRequireWildcard(require("d3-selection"));
var d3Transition = _interopRequireWildcard(require("d3-transition"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/document_count_chart_single_brush/single_brush.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO Consolidate with similar component `DualBrush` in
// x-pack/packages/private/ml/aiops_components/src/dual_brush/dual_brush.tsx

const {
  brush,
  brushSelection,
  brushX
} = d3Brush;
const {
  scaleLinear
} = d3Scale;
const {
  select: d3Select
} = d3Selection;
// Import fix to apply correct types for the use of d3.select(this).transition()
d3Select.prototype.transition = d3Transition.transition;
const getSingleBrushWindowParameters = (clickTime, minTime, maxTime) => {
  // Workout ideal bounds for the brush when user clicks on the chart
  const totalWindow = maxTime - minTime;

  // min brush window
  const minDeviationWindow = 10 * 60 * 1000; // 10min

  // work out bounds as done in the original notebooks,
  // with the brush window aiming to be a 1/10
  // of the size of the total window and the baseline window
  // being 3.5/10 of the total window.
  const brushWindow = Math.max(totalWindow / 10, minDeviationWindow);
  const brushMin = clickTime - brushWindow / 2;
  const brushMax = clickTime + brushWindow / 2;
  return {
    min: Math.round(brushMin),
    max: Math.round(brushMax)
  };
};
exports.getSingleBrushWindowParameters = getSingleBrushWindowParameters;
const getSnappedSingleBrushWindowParameters = (windowParameters, snapTimestamps) => {
  const snappedBaselineMin = snapTimestamps.reduce((pts, cts) => {
    if (Math.abs(cts - windowParameters.min) < Math.abs(pts - windowParameters.min)) {
      return cts;
    }
    return pts;
  }, snapTimestamps[0]);
  const baselineMaxTimestamps = snapTimestamps.filter(ts => ts > snappedBaselineMin);
  const snappedBaselineMax = baselineMaxTimestamps.reduce((pts, cts) => {
    if (Math.abs(cts - windowParameters.max) < Math.abs(pts - windowParameters.max)) {
      return cts;
    }
    return pts;
  }, baselineMaxTimestamps[0]);
  return {
    min: snappedBaselineMin,
    max: snappedBaselineMax
  };
};
exports.getSnappedSingleBrushWindowParameters = getSnappedSingleBrushWindowParameters;
const d3 = {
  brush,
  brushSelection,
  brushX,
  scaleLinear,
  select: d3Select,
  transition: d3Transition
};
const isBrushXSelection = arg => {
  return Array.isArray(arg) && arg.length === 2 && typeof arg[0] === 'number' && typeof arg[1] === 'number';
};
const BRUSH_HEIGHT = 20;
const BRUSH_MARGIN = 4;
const BRUSH_HANDLE_SIZE = 4;
const BRUSH_HANDLE_ROUNDED_CORNER = 2;

/**
 * Props for the SingleBrush React Component
 */

/**
 * SingleBrush React Component
 * Single brush component that overlays the document count chart
 *
 * @param props SingleBrushProps component props
 * @returns The SingleBrush component.
 */
const SingleBrush = props => {
  const {
    id: brushId = '',
    windowParameters,
    min,
    max,
    onChange,
    marginLeft,
    snapTimestamps,
    width
  } = props;
  const d3BrushContainer = (0, _react.useRef)(null);
  const brushes = (0, _react.useRef)([]);

  // We need to pass props to refs here because the d3-brush code doesn't consider
  // native React prop changes. The brush code does its own check whether these props changed then.
  // The initialized brushes might otherwise act on stale data.
  const widthRef = (0, _react.useRef)(width);
  const minRef = (0, _react.useRef)(min);
  const maxRef = (0, _react.useRef)(max);
  const snapTimestampsRef = (0, _react.useRef)(snapTimestamps);
  const {
    min: baselineMin,
    max: baselineMax
  } = windowParameters;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleFillColor = euiTheme.colors.darkShade;
  (0, _react.useEffect)(() => {
    if (d3BrushContainer.current && width > 0) {
      const gBrushes = d3.select(d3BrushContainer.current);
      function newBrush(id, start, end) {
        brushes.current.push({
          id,
          brush: d3.brushX().handleSize(BRUSH_HANDLE_SIZE).on('end', brushend),
          start,
          end
        });
        function brushend() {
          var _x, _x2, _x3, _x4;
          const currentWidth = widthRef.current;
          const x = d3.scaleLinear().domain([minRef.current, maxRef.current]).rangeRound([0, currentWidth]);
          const px2ts = px => Math.round(x.invert(px));
          const xMin = (_x = x(minRef.current)) !== null && _x !== void 0 ? _x : 0;
          const xMax = (_x2 = x(maxRef.current)) !== null && _x2 !== void 0 ? _x2 : 0;
          const minExtentPx = Math.round((xMax - xMin) / 100);
          const baselineBrush = d3.select(`#data-drift-${brushId}`);
          const baselineSelection = d3.brushSelection(baselineBrush.node());
          if (!isBrushXSelection(baselineSelection)) {
            return;
          }
          const newWindowParameters = {
            min: px2ts(baselineSelection[0]),
            max: px2ts(baselineSelection[1])
          };
          if (id === `${brushId}` && baselineSelection) {
            const newBaselineMax = baselineSelection[1];
            const newBaselineMin = Math.min(baselineSelection[0], newBaselineMax - minExtentPx);
            newWindowParameters.min = px2ts(newBaselineMin);
            newWindowParameters.max = px2ts(newBaselineMax);
          }
          const snappedWindowParameters = snapTimestampsRef.current ? getSnappedSingleBrushWindowParameters(newWindowParameters, snapTimestampsRef.current) : newWindowParameters;
          const newBrushPx = {
            min: (_x3 = x(snappedWindowParameters.min)) !== null && _x3 !== void 0 ? _x3 : 0,
            max: (_x4 = x(snappedWindowParameters.max)) !== null && _x4 !== void 0 ? _x4 : 0
          };
          if (id === `${brushId}` && (baselineSelection[0] !== newBrushPx.min || baselineSelection[1] !== newBrushPx.max)) {
            d3.select(this).transition().duration(200)
            // @ts-expect-error call doesn't allow the brush move function
            .call(brushes.current[0].brush.move, [newBrushPx.min, newBrushPx.max]);
          }
          brushes.current[0].start = snappedWindowParameters.min;
          brushes.current[0].end = snappedWindowParameters.max;
          if (onChange) {
            onChange({
              min: snappedWindowParameters.min,
              max: snappedWindowParameters.max
            }, {
              min: newBrushPx.min,
              max: newBrushPx.max
            });
          }
          drawBrushes();
        }
      }
      function drawBrushes() {
        const mlBrushSelection = gBrushes.selectAll('.brush').data(brushes.current, d => d.id);

        // Set up new brushes
        mlBrushSelection.enter().insert('g', '.brush').attr('class', 'brush').attr('id', b => {
          return 'data-drift-' + b.id;
        }).attr('data-test-subj', b => {
          return 'dataDriftBrush-' + b.id.charAt(0).toUpperCase() + b.id.slice(1);
        }).each((brushObject, i, n) => {
          var _x5, _x6;
          const x = d3.scaleLinear().domain([min, max]).rangeRound([0, widthRef.current]);
          // Ensure brush style is applied
          brushObject.brush.extent([[0, BRUSH_MARGIN], [widthRef.current, BRUSH_HEIGHT - BRUSH_MARGIN]]);
          brushObject.brush(d3.select(n[i]));
          const xStart = (_x5 = x(brushObject.start)) !== null && _x5 !== void 0 ? _x5 : 0;
          const xEnd = (_x6 = x(brushObject.end)) !== null && _x6 !== void 0 ? _x6 : 0;
          brushObject.brush.move(d3.select(n[i]), [xStart, xEnd]);
        });

        // disable drag-select to reset a brush's selection
        mlBrushSelection.attr('class', 'brush').selectAll('.overlay').attr('width', widthRef.current).style('pointer-events', 'none');
        mlBrushSelection.selectAll('.handle').attr('fill', handleFillColor).attr('rx', BRUSH_HANDLE_ROUNDED_CORNER).attr('ry', BRUSH_HANDLE_ROUNDED_CORNER);
        mlBrushSelection.exit().remove();
      }
      function updateBrush() {
        const mlBrushSelection = gBrushes.selectAll('.brush').data(brushes.current, d => d.id);
        mlBrushSelection.each(function (brushObject, i, n) {
          var _x7, _x8;
          const x = d3.scaleLinear().domain([minRef.current, maxRef.current]).rangeRound([0, widthRef.current]);
          brushObject.brush.extent([[0, BRUSH_MARGIN], [widthRef.current, BRUSH_HEIGHT - BRUSH_MARGIN]]);
          brushObject.brush(d3.select(n[i]));
          const xStart = (_x7 = x(brushObject.start)) !== null && _x7 !== void 0 ? _x7 : 0;
          const xEnd = (_x8 = x(brushObject.end)) !== null && _x8 !== void 0 ? _x8 : 0;
          brushObject.brush.move(d3.select(n[i]), [xStart, xEnd]);
        });
      }
      if (brushes.current.length !== 1) {
        widthRef.current = width;
        newBrush(`${brushId}`, baselineMin, baselineMax);
      } else if (widthRef.current !== width || minRef.current !== min || maxRef.current !== max || !(0, _lodash.isEqual)(snapTimestampsRef.current, snapTimestamps)) {
        widthRef.current = width;
        minRef.current = min;
        maxRef.current = max;
        snapTimestampsRef.current = snapTimestamps;
        updateBrush();
      }
      drawBrushes();
    }
  }, [min, max, width, baselineMin, baselineMax, snapTimestamps, onChange, brushId, handleFillColor]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, width > 0 && /*#__PURE__*/_react.default.createElement("svg", {
    className: "data-drift-brush",
    "data-test-subj": "dataDriftBrush",
    width: width,
    height: BRUSH_HEIGHT,
    style: {
      marginLeft
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    className: "brushes",
    width: width,
    ref: d3BrushContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  })));
};
exports.SingleBrush = SingleBrush;