"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageHeader = exports.DataDriftPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _use_state_manager = require("./use_state_manager");
var _use_data = require("../common/hooks/use_data");
var _storage = require("../index_data_visualizer/types/storage");
var _types = require("./types");
var _data_source_context = require("../common/hooks/data_source_context");
var _kibana_context = require("../kibana_context");
var _data_drift_view = require("./data_drift_view");
var _constants = require("./constants");
var _search_bar = require("../index_data_visualizer/components/search_panel/search_bar");
var _use_search = require("../common/hooks/use_search");
var _document_count_with_brush = require("./document_count_with_brush");
var _use_data_drift_colors = require("./use_data_drift_colors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/data_drift_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const dataViewTitleHeader = (0, _react2.css)({
  minWidth: '300px'
});
const PageHeader = ({
  onRefresh,
  needsUpdate
}) => {
  const [, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    dataView
  } = (0, _data_source_context.useDataSource)();
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.DV_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: dataView.timeFieldName !== undefined,
    autoRefreshSelector: true
  });
  const updateTimeState = (0, _react.useCallback)(update => {
    setGlobalState({
      time: {
        from: (0, _moment.default)(update.start.epoch).toISOString(),
        to: (0, _moment.default)(update.end.epoch).toISOString()
      }
    });
  }, [setGlobalState]);
  const hasValidTimeField = (0, _react.useMemo)(() => dataView && dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": 'mlDataDriftPageDataViewTitle',
      css: dataViewTitleHeader,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }, dataView.getName()),
    rightSideGroupProps: {
      gutterSize: 's',
      'data-test-subj': 'dataComparisonTimeRangeSelectorSection'
    },
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerWrapper, {
      isAutoRefreshOnly: !hasValidTimeField,
      showRefresh: !hasValidTimeField,
      width: "full",
      onRefresh: onRefresh,
      needsUpdate: needsUpdate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }), hasValidTimeField && /*#__PURE__*/_react.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
      frozenDataPreference: frozenDataPreference,
      setFrozenDataPreference: setFrozenDataPreference,
      dataView: dataView,
      query: undefined,
      disabled: false,
      timefilter: timefilter,
      callback: updateTimeState,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    })].filter(Boolean),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  });
};
exports.PageHeader = PageHeader;
const getDataDriftDataLabel = (label, indexPattern) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 139,
    columnNumber: 5
  }
}, label), ' ' + _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.dataLabel', {
  defaultMessage: 'data'
}) + (indexPattern ? `: ${indexPattern}` : ''));
const isBarBetween = (start, end, min, max) => {
  return start >= min && end <= max;
};
const DataDriftPage = ({
  initialSettings
}) => {
  const {
    services: {
      data: dataService,
      uiSettings
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    dataView,
    savedSearch
  } = (0, _data_source_context.useDataSource)();
  const {
    reference: referenceStateManager,
    comparison: comparisonStateManager
  } = (0, _use_state_manager.useDataDriftStateManagerContext)();
  const [dataComparisonListState, setDataComparisonListState] = (0, _mlUrlState.usePageUrlState)('DV_DATA_DRIFT', (0, _types.getDefaultDataComparisonState)());
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(0);
  const forceRefresh = (0, _react.useCallback)(() => setLastRefresh(Date.now()), [setLastRefresh]);
  const randomSampler = (0, _react.useMemo)(() => referenceStateManager.randomSampler, [referenceStateManager]);
  const randomSamplerProd = (0, _react.useMemo)(() => comparisonStateManager.randomSampler, [comparisonStateManager]);
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [selectedSavedSearch, setSelectedSavedSearch] = (0, _react.useState)(savedSearch);
  const [localQueryString, setLocalQueryString] = (0, _react.useState)(dataComparisonListState.searchString);
  (0, _react.useEffect)(() => {
    if (savedSearch) {
      setSelectedSavedSearch(savedSearch);
    }
  }, [savedSearch]);
  const setSearchParams = (0, _react.useCallback)(searchParams => {
    // When the user loads a saved search and then clears or modifies the query
    // we should remove the saved search and replace it with the index pattern id
    if (selectedSavedSearch !== null) {
      setSelectedSavedSearch(null);
    }
    setDataComparisonListState({
      ...dataComparisonListState,
      searchQuery: searchParams.searchQuery,
      searchString: searchParams.searchString,
      searchQueryLanguage: searchParams.queryLanguage,
      filters: searchParams.filters
    });
  }, [selectedSavedSearch, dataComparisonListState, setDataComparisonListState]);
  const {
    searchQueryLanguage,
    searchString,
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch
  }, dataComparisonListState);
  const {
    documentStats,
    documentStatsProd,
    timefilter
  } = (0, _use_data.useData)(initialSettings, dataView, 'data_drift', searchString, searchQueryLanguage, randomSampler, randomSamplerProd, setGlobalState, undefined);
  const {
    sampleProbability,
    totalCount,
    documentCountStats,
    documentCountStatsCompare
  } = documentStats;
  (0, _react.useEffect)(() => {
    randomSampler.setDocCount(totalCount);
  }, [totalCount, randomSampler]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  (0, _react.useEffect)(() => {
    // Update data query manager if input string is updated
    dataService === null || dataService === void 0 ? void 0 : dataService.query.queryString.setQuery({
      query: searchString !== null && searchString !== void 0 ? searchString : '',
      language: searchQueryLanguage
    });
  }, [dataService, searchQueryLanguage, searchString]);
  const colors = (0, _use_data_drift_colors.useDataDriftColors)();
  const [brushRanges, setBrushRanges] = (0, _react.useState)();

  // Ref to keep track of previous values
  const brushRangesRef = (0, _react.useRef)({});
  const [initialAnalysisStart, setInitialAnalysisStart] = (0, _react.useState)();
  const [isBrushCleared, setIsBrushCleared] = (0, _react.useState)(true);
  const referenceBrushSelectionUpdate = (0, _react.useCallback)(function referenceBrushSelectionUpdate(d, force) {
    if (!isBrushCleared || force) {
      const clone = (0, _lodash.cloneDeep)(brushRangesRef.current);
      clone.baselineMin = d.min;
      clone.baselineMax = d.max;
      brushRangesRef.current = clone;
      setBrushRanges(clone);
    }
    if (force) {
      setIsBrushCleared(false);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [brushRanges, isBrushCleared]);
  const comparisonBrushSelectionUpdate = (0, _react.useCallback)(function comparisonBrushSelectionUpdate(d, force) {
    if (!isBrushCleared || force) {
      const clone = (0, _lodash.cloneDeep)(brushRangesRef.current);
      clone.deviationMin = d.min;
      clone.deviationMax = d.max;
      brushRangesRef.current = clone;
      setBrushRanges(clone);
    }
    if (force) {
      setIsBrushCleared(false);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [brushRanges, isBrushCleared]);
  function clearSelection() {
    setBrushRanges(undefined);
    setIsBrushCleared(true);
    setInitialAnalysisStart(undefined);
  }
  const barStyleAccessor = (0, _react.useCallback)(datum => {
    var _documentCountStats$i;
    if (!brushRanges) return null;
    const start = typeof datum.x === 'string' ? parseInt(datum.x, 10) : datum.x;
    const end = start + ((_documentCountStats$i = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.interval) !== null && _documentCountStats$i !== void 0 ? _documentCountStats$i : 0);
    const isBetweenReference = isBarBetween(start, end, brushRanges.baselineMin, brushRanges.baselineMax);
    const isBetweenDeviation = isBarBetween(start, end, brushRanges.deviationMin, brushRanges.deviationMax);
    if (isBetweenReference && isBetweenDeviation) return colors.overlapColor;
    if (isBetweenReference) return colors.referenceColor;
    if (isBetweenDeviation) return colors.comparisonColor;
    return null;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [JSON.stringify({
    brushRanges,
    colors
  })]);
  const hasValidTimeField = (0, _react.useMemo)(() => dataView && dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView]);
  const referenceIndexPatternLabel = initialSettings !== null && initialSettings !== void 0 && initialSettings.reference ? getDataDriftDataLabel(_constants.REFERENCE_LABEL, initialSettings.reference) : getDataDriftDataLabel(_constants.REFERENCE_LABEL);
  const comparisonIndexPatternLabel = initialSettings !== null && initialSettings !== void 0 && initialSettings.comparison ? getDataDriftDataLabel(_constants.COMPARISON_LABEL, initialSettings === null || initialSettings === void 0 ? void 0 : initialSettings.comparison) : getDataDriftDataLabel(_constants.COMPARISON_LABEL);
  const onQueryChange = (0, _react.useCallback)(query => {
    setLocalQueryString(query);
  }, []);
  const queryNeedsUpdate = (0, _react.useMemo)(() => localQueryString !== dataComparisonListState.searchString, [dataComparisonListState.searchString, localQueryString]);
  const handleRefresh = (0, _react.useCallback)(() => {
    if (queryNeedsUpdate) {
      var _dataService$query$fi;
      const newQuery = (0, _esQuery.buildEsQuery)(dataView, {
        query: localQueryString || '',
        language: searchQueryLanguage
      }, (_dataService$query$fi = dataService === null || dataService === void 0 ? void 0 : dataService.query.filterManager.getFilters()) !== null && _dataService$query$fi !== void 0 ? _dataService$query$fi : [], uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
      setDataComparisonListState({
        ...dataComparisonListState,
        searchString: localQueryString,
        searchQuery: newQuery
      });
    }
  }, [queryNeedsUpdate, dataView, localQueryString, searchQueryLanguage, dataService === null || dataService === void 0 ? void 0 : dataService.query.filterManager, uiSettings, setDataComparisonListState, dataComparisonListState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "dataComparisonDataDriftPage",
    paddingSize: "none",
    panelled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(PageHeader, {
    onRefresh: handleRefresh,
    needsUpdate: queryNeedsUpdate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchPanelContent, {
    dataView: dataView,
    searchString: searchString,
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage,
    setSearchParams: setSearchParams,
    onQueryChange: onQueryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_document_count_with_brush.DocumentCountWithBrush, {
    id: _constants.REFERENCE_LABEL,
    label: referenceIndexPatternLabel,
    randomSampler: randomSampler,
    reload: forceRefresh,
    brushSelectionUpdateHandler: referenceBrushSelectionUpdate,
    documentCountStats: documentCountStats,
    documentCountStatsSplit: documentCountStatsCompare,
    isBrushCleared: isBrushCleared,
    totalCount: totalCount,
    approximate: sampleProbability < 1,
    sampleProbability: sampleProbability,
    initialAnalysisStart: initialAnalysisStart,
    barStyleAccessor: barStyleAccessor,
    brush: {
      label: _constants.REFERENCE_LABEL,
      annotationStyle: {
        strokeWidth: 0,
        stroke: colors.referenceColor,
        fill: colors.referenceColor,
        opacity: 0.5
      },
      badgeWidth: 80
    },
    stateManager: referenceStateManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_document_count_with_brush.DocumentCountWithBrush, {
    id: _constants.COMPARISON_LABEL,
    label: comparisonIndexPatternLabel,
    randomSampler: randomSamplerProd,
    reload: forceRefresh,
    brushSelectionUpdateHandler: comparisonBrushSelectionUpdate,
    documentCountStats: documentStatsProd.documentCountStats,
    documentCountStatsSplit: documentStatsProd.documentCountStatsCompare,
    isBrushCleared: isBrushCleared,
    totalCount: documentStatsProd.totalCount,
    approximate: documentStatsProd.sampleProbability < 1,
    sampleProbability: documentStatsProd.sampleProbability,
    initialAnalysisStart: initialAnalysisStart,
    barStyleAccessor: barStyleAccessor,
    brush: {
      label: _constants.COMPARISON_LABEL,
      annotationStyle: {
        strokeWidth: 0,
        stroke: colors.comparisonColor,
        fill: colors.comparisonColor,
        opacity: 0.5
      },
      badgeWidth: 90
    },
    stateManager: comparisonStateManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_data_drift_view.DataDriftView, {
    initialSettings: initialSettings,
    isBrushCleared: isBrushCleared,
    onReset: clearSelection,
    windowParameters: brushRanges,
    dataView: dataView,
    searchString: searchString !== null && searchString !== void 0 ? searchString : '',
    searchQueryLanguage: searchQueryLanguage,
    lastRefresh: lastRefresh,
    onRefresh: forceRefresh,
    hasValidTimeField: hasValidTimeField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 15
    }
  }))))));
};
exports.DataDriftPage = DataDriftPage;