"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldNames = getFieldNames;
exports.getSupportedFieldType = getSupportedFieldType;
var _lodash = require("lodash");
var _fieldTypes = require("@kbn/field-types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// clone of data viz code. this should be removed and the data viz code moved to a common package

function getFieldNames(results) {
  const {
    mappings,
    field_stats: fieldStats,
    column_names: columnNames
  } = results;

  // if columnNames exists (i.e delimited) use it for the field list
  // so we get the same order
  const tempFields = columnNames !== undefined ? columnNames : Object.keys(fieldStats);

  // there may be fields in the mappings which do not exist in the field_stats
  // e.g. the message field for a semi-structured log file, as they have no stats.
  // add any extra fields to the list
  const differenceFields = (0, _lodash.difference)(Object.keys(mappings.properties), tempFields);

  // except @timestamp
  const timestampIndex = differenceFields.indexOf('@timestamp');
  if (timestampIndex !== -1) {
    differenceFields.splice(timestampIndex, 1);
  }
  if (differenceFields.length) {
    tempFields.push(...differenceFields);
  }
  return tempFields;
}
function getSupportedFieldType(type) {
  switch (type) {
    case _fieldTypes.ES_FIELD_TYPES.FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.DOUBLE:
    case _fieldTypes.ES_FIELD_TYPES.INTEGER:
    case _fieldTypes.ES_FIELD_TYPES.LONG:
    case _fieldTypes.ES_FIELD_TYPES.SHORT:
    case _fieldTypes.ES_FIELD_TYPES.UNSIGNED_LONG:
      return _constants.SUPPORTED_FIELD_TYPES.NUMBER;
    case _fieldTypes.ES_FIELD_TYPES.DATE:
    case _fieldTypes.ES_FIELD_TYPES.DATE_NANOS:
      return _constants.SUPPORTED_FIELD_TYPES.DATE;
    default:
      return type;
  }
}