"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSelectorFactory = exports.matchedIndiciesDefault = exports.DataViewMgmtService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _common = require("@kbn/data-views-plugin/common");
var _public = require("@kbn/kibana-utils-plugin/public");
var _utils = require("../components/edit_index_pattern/tabs/utils");
var _utils2 = require("../components/utils");
var _edit_index_pattern_state_container = require("../components/edit_index_pattern/edit_index_pattern_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const matchedIndiciesDefault = exports.matchedIndiciesDefault = {
  allIndices: [],
  exactMatchedIndices: [],
  partialMatchedIndices: [],
  visibleIndices: []
};

/**
 * ConstructorArgs for DataViewEditorService
 */

const defaultDataViewEditorState = {
  allowedTypes: [],
  relationships: [],
  fields: [],
  scriptedFields: [],
  scriptedFieldLangs: [],
  indexedFieldTypes: [],
  fieldConflictCount: 0,
  tags: [],
  isRefreshing: true,
  defaultIndex: '',
  conflictFieldsUrl: ''
};
const stateSelectorFactory = state$ => (selector, equalityFn) => state$.pipe((0, _rxjs.map)(selector), (0, _rxjs.distinctUntilChanged)(equalityFn));
exports.stateSelectorFactory = stateSelectorFactory;
class DataViewMgmtService {
  constructor({
    services: {
      dataViews,
      savedObjectsManagement,
      uiSettings,
      application
    },
    initialValues: {}
  }) {
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "allowedTypes", void 0);
    (0, _defineProperty2.default)(this, "internalState$", void 0);
    (0, _defineProperty2.default)(this, "state$", void 0);
    (0, _defineProperty2.default)(this, "updateState", newState => {
      this.internalState$.next({
        ...this.state$.getValue(),
        ...newState
      });
    });
    (0, _defineProperty2.default)(this, "getConflictFieldsKbnUrl", dataViewId => (0, _public.setStateToKbnUrl)(_edit_index_pattern_state_container.APP_STATE_STORAGE_KEY, {
      fieldTypes: ['conflict'],
      tab: 'indexedFields'
    }, {
      useHash: this.services.uiSettings.get('state:storeInSessionStorage')
    }, this.services.application.getUrlForApp('management', {
      path: `/kibana/dataViews/dataView/${encodeURIComponent(dataViewId)}`
    })));
    (0, _defineProperty2.default)(this, "getTags", async dataView => {
      if (dataView) {
        const defaultIndex = await this.services.uiSettings.get('defaultIndex');
        const tags = (0, _utils2.getTags)(dataView, dataView.id === defaultIndex, this.services.dataViews.getRollupsEnabled());
        return tags;
      }
      return [];
    });
    this.services = {
      application,
      dataViews,
      savedObjectsManagement,
      uiSettings
    };
    this.internalState$ = new _rxjs.BehaviorSubject({
      ...defaultDataViewEditorState
    });
    this.state$ = this.internalState$;

    // allowed types are set once and never change
    this.allowedTypes = new Promise(resolve => {
      savedObjectsManagement.getAllowedTypes().then(resp => {
        this.updateState({
          allowedTypes: resp
        });
        resolve(resp);
      });
    });
  }
  async updateScriptedFields() {
    const dataView = this.state$.getValue().dataView;
    if (dataView) {
      const scriptedFieldRecords = dataView.getScriptedFields();
      const scriptedFields = Object.values(scriptedFieldRecords);
      const scriptedFieldLangs = Array.from(scriptedFields.reduce((acc, field) => {
        if (field.lang) {
          acc.add(field.lang);
        }
        return acc;
      }, new Set()));
      this.updateState({
        scriptedFields,
        scriptedFieldLangs: (0, _utils.convertToEuiSelectableOptionsFromArray)(scriptedFieldLangs)
      });
    }
  }
  async setDataView(dataView) {
    this.updateState({
      isRefreshing: true
    });
    const fieldRecords = dataView.fields.filter(field => !field.scripted).reduce((acc, field) => {
      acc[field.name] = field;
      return acc;
    }, {});
    const fields = Object.values(fieldRecords);
    const indexedFieldTypes = new Set();
    fields.forEach(field => {
      // for conflicted fields, add conflict as a type
      if (field.type === 'conflict') {
        indexedFieldTypes.add('conflict');
      }
      if (field.esTypes) {
        // add all types, may be multiple
        field.esTypes.forEach(item => indexedFieldTypes.add(item));
      }
    });
    const allowedAsString = (await this.allowedTypes).map(item => item.name);
    this.services.savedObjectsManagement.getRelationships(_common.DATA_VIEW_SAVED_OBJECT_TYPE, dataView.id, allowedAsString).then(resp => {
      this.updateState({
        relationships: resp.relations.map(r => ({
          ...r,
          title: r.meta.title
        }))
      });
    });
    this.updateState({
      dataView,
      fields,
      indexedFieldTypes: (0, _utils.convertToEuiSelectableOptionsFromArray)(Array.from(indexedFieldTypes)),
      fieldConflictCount: fields.filter(field => field.type === 'conflict').length,
      tags: await this.getTags(dataView),
      defaultIndex: await this.services.uiSettings.get('defaultIndex'),
      isRefreshing: false,
      conflictFieldsUrl: this.getConflictFieldsKbnUrl(dataView.id),
      scriptedFields: dataView.getScriptedFields()
    });
    this.updateScriptedFields();
  }
  async refreshFields() {
    const dataView = this.state$.getValue().dataView;
    if (dataView) {
      await this.services.dataViews.refreshFields(dataView, undefined, true);
      return this.setDataView(dataView);
    }
  }
  async setDefaultDataView() {
    const dataView = this.internalState$.getValue().dataView;
    if (!dataView) {
      return;
    }
    await this.services.uiSettings.set('defaultIndex', dataView.id);
    this.updateState({
      tags: await this.getTags(dataView),
      defaultIndex: dataView.id
    });
  }
}
exports.DataViewMgmtService = DataViewMgmtService;