"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showDelete = exports.renderFieldName = exports.getConflictModalContent = exports.TableWithoutPersist = exports.Table = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fieldUtils = require("@kbn/field-utils");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/indexed_fields_table/components/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showDelete = field => {
  var _field$runtimeField, _field$runtimeField2;
  return (
    // runtime fields that aren't composite subfields
    !field.isMapped && field.isUserEditable && ((_field$runtimeField = field.runtimeField) === null || _field$runtimeField === void 0 ? void 0 : _field$runtimeField.type) !== 'composite' ||
    // composite runtime field definitions
    ((_field$runtimeField2 = field.runtimeField) === null || _field$runtimeField2 === void 0 ? void 0 : _field$runtimeField2.type) === 'composite' && field.type === 'composite'
  );
};

// localized labels
exports.showDelete = showDelete;
const additionalInfoAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.additionalInfoAriaLabel', {
  defaultMessage: 'Additional field information'
});
const conflictDetailIconAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.conflictDetailIconAria', {
  defaultMessage: 'Conflict Detail'
});
const primaryTimeAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.primaryTimeAriaLabel', {
  defaultMessage: 'Primary time field'
});
const primaryTimeTooltip = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.primaryTimeTooltip', {
  defaultMessage: 'This field represents the time that events occurred.'
});
const nameHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.nameHeader', {
  defaultMessage: 'Name'
});
const typeHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.typeHeader', {
  defaultMessage: 'Type'
});
const formatHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.formatHeader', {
  defaultMessage: 'Format'
});
const searchableHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.searchableHeader', {
  defaultMessage: 'Searchable'
});
const searchableDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.searchableDescription', {
  defaultMessage: 'These fields can be used in the filter bar'
});
const isSearchableAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.isSearchableAria', {
  defaultMessage: 'Is searchable'
});
const aggregatableLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.aggregatableLabel', {
  defaultMessage: 'Aggregatable'
});
const aggregatableDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.aggregatableDescription', {
  defaultMessage: 'These fields can be used in visualization aggregations'
});
const isAggregatableAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.isAggregatableAria', {
  defaultMessage: 'Is aggregatable'
});
const excludedLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.excludedLabel', {
  defaultMessage: 'Excluded'
});
const excludedDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.excludedDescription', {
  defaultMessage: 'Fields that are excluded from _source when it is fetched'
});
const isExcludedAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.isExcludedAria', {
  defaultMessage: 'Is excluded'
});
const actionsLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.actionsLabel', {
  defaultMessage: 'Actions'
});
const editLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.editLabel', {
  defaultMessage: 'Edit'
});
const editDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.editDescription', {
  defaultMessage: 'Edit'
});
const deleteLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.deleteLabel', {
  defaultMessage: 'Delete'
});
const deleteDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.deleteDescription', {
  defaultMessage: 'Delete'
});
const labelDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.customLabelTooltip', {
  defaultMessage: 'A custom label for the field.'
});
function runtimeIconTipTitle(fld) {
  var _fld$runtimeField;
  // composite runtime fields
  if (((_fld$runtimeField = fld.runtimeField) === null || _fld$runtimeField === void 0 ? void 0 : _fld$runtimeField.type) === 'composite') {
    // subfields definitions
    if (fld.type !== 'composite') {
      return _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.runtimeIconTipTitleCompositeSubfield', {
        defaultMessage: 'Composite runtime subfield'
      });
      // composite definitions
    } else {
      return _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.runtimeIconTipTitleComposite', {
        defaultMessage: 'Composite runtime field'
      });
    }
  }
  return _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.runtimeIconTipTitle', {
    defaultMessage: 'Runtime field'
  });
}
const runtimeIconTipText = _i18n.i18n.translate('indexPatternManagement.editDataView.fields.table.runtimeIconTipText', {
  defaultMessage: 'This field exists on the data view only.'
});
const conflictType = _i18n.i18n.translate('indexPatternManagement.editDataView.fields.table.conflictType', {
  defaultMessage: 'Conflict'
});
const getItems = conflictDescriptions => {
  const typesAndIndices = [];
  Object.keys(conflictDescriptions).forEach(type => {
    // only show first 100 indices just incase the list is CRAZY long
    typesAndIndices.push({
      type,
      indices: conflictDescriptions[type].slice(0, 99).join(', ')
    });
  });
  return typesAndIndices;
};
const renderFieldName = (field, timeFieldName) => /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": `field-name-${field.name}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 238,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 239,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_fieldUtils.FieldIcon, {
  type: (0, _fieldUtils.getFieldIconType)(field, f => f === null || f === void 0 ? void 0 : f.kbnType),
  scripted: field === null || field === void 0 ? void 0 : field.scripted,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 240,
    columnNumber: 7
  }
}), field.name, field.info && field.info.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  type: "question",
  color: "primary",
  "aria-label": additionalInfoAriaLabel,
  content: field.info.map((info, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }, info)),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 243,
    columnNumber: 9
  }
}) : null, timeFieldName === field.name ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  type: "clock",
  color: "primary",
  "aria-label": primaryTimeAriaLabel,
  content: primaryTimeTooltip,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 253,
    columnNumber: 9
  }
}) : null, !field.isMapped && field.hasRuntime ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  type: "indexRuntime",
  title: runtimeIconTipTitle(field),
  content: runtimeIconTipText,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 261,
    columnNumber: 9
  }
}) : null), field.customLabel && field.customLabel !== field.name ? /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 269,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: labelDescription,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 270,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "flag",
  iconSide: "left",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 271,
    columnNumber: 11
  }
}, field.customLabel))) : null, field.customDescription ? /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 278,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 279,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_fieldUtils.FieldDescription, {
  field: field,
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 280,
    columnNumber: 9
  }
})) : null);
exports.renderFieldName = renderFieldName;
const conflictColumns = [{
  field: 'type',
  name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.conflictModalTypeColumn', {
    defaultMessage: 'Type'
  })
}, {
  field: 'indices',
  name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.conflictModalIndicesColumn', {
    defaultMessage: 'Indices'
  })
}];
const getConflictModalContent = ({
  closeFn,
  fieldName,
  conflictDescriptions
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 313,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 314,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternManagement.editIndexPattern.fields.conflictModal.title",
  defaultMessage: "This field has a type conflict",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 315,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 321,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 322,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 323,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternManagement.editIndexPattern.fields.conflictModal.description",
  defaultMessage: "The type of the {fieldName} field changes across indices and might not be available for search, visualizations, and other analysis.",
  values: {
    fieldName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 34
      }
    }, fieldName)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 324,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
  tableCaption: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.conflictModal.tableCaption', {
    defaultMessage: 'Field type conflicts across indices'
  }),
  items: getItems(conflictDescriptions),
  rowHeader: "firstName",
  columns: conflictColumns,
  tableLayout: "auto",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 330,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 342,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: closeFn,
  fill: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 343,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternManagement.editIndexPattern.fields.conflictModal.closeBtn",
  defaultMessage: "Close",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 344,
    columnNumber: 9
  }
}))));
exports.getConflictModalContent = getConflictModalContent;
const getConflictBtn = (fieldName, conflictDescriptions, openModal, startServices) => {
  const onClick = () => {
    const overlayRef = openModal((0, _reactKibanaMount.toMountPoint)(getConflictModalContent({
      closeFn: () => {
        overlayRef.close();
      },
      fieldName,
      conflictDescriptions
    }), startServices));
  };
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 5
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    iconType: "warning",
    onClick: onClick,
    iconOnClick: onClick,
    iconOnClickAriaLabel: conflictDetailIconAria,
    onClickAriaLabel: conflictDetailIconAria,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 7
    }
  }, conflictType));
};
const PAGE_SIZE_OPTIONS = [5, 10, 25, 50];
class TableClass extends _react.PureComponent {
  renderBooleanTemplate(value, arialLabel) {
    return value ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: "success",
      "aria-label": arialLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 20
      }
    }) : /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 85
      }
    });
  }
  renderFieldType(type, field) {
    const conflictDescription = field.conflictDescriptions && field.conflictDescriptions[field.name];
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 7
      }
    }, type === 'conflict' && conflictDescription ? '' : type, field.conflictDescriptions ? getConflictBtn(field.name, field.conflictDescriptions, this.props.openModal, this.props.startServices) : '');
  }
  render() {
    const {
      items,
      editField,
      deleteField,
      indexPattern,
      euiTablePersist: {
        pageSize,
        sorting,
        onTableChange
      }
    } = this.props;
    const pagination = {
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
    const columns = [{
      field: 'displayName',
      name: nameHeader,
      dataType: 'string',
      sortable: true,
      render: (_value, field) => {
        return renderFieldName(field, indexPattern.timeFieldName);
      },
      width: '38%',
      'data-test-subj': 'indexedFieldName'
    }, {
      field: 'type',
      name: typeHeader,
      dataType: 'string',
      sortable: true,
      render: (value, field) => {
        return this.renderFieldType(value, field);
      },
      'data-test-subj': 'indexedFieldType'
    }, {
      field: 'format',
      name: formatHeader,
      dataType: 'string',
      sortable: true
    }, {
      field: 'searchable',
      name: searchableHeader,
      description: searchableDescription,
      dataType: 'boolean',
      sortable: true,
      render: value => this.renderBooleanTemplate(value, isSearchableAriaLabel)
    }, {
      field: 'aggregatable',
      name: aggregatableLabel,
      description: aggregatableDescription,
      dataType: 'boolean',
      sortable: true,
      render: value => this.renderBooleanTemplate(value, isAggregatableAriaLabel)
    }, {
      field: 'excluded',
      name: excludedLabel,
      description: excludedDescription,
      dataType: 'boolean',
      sortable: true,
      render: value => this.renderBooleanTemplate(value, isExcludedAriaLabel)
    }, {
      name: actionsLabel,
      actions: [{
        name: editLabel,
        description: editDescription,
        icon: 'pencil',
        onClick: editField,
        type: 'icon',
        'data-test-subj': 'editFieldFormat',
        available: field => field.isUserEditable
      }, {
        name: deleteLabel,
        description: deleteDescription,
        icon: 'trash',
        color: 'danger',
        onClick: field => {
          var _field$spec, _field$spec$runtimeFi;
          const toDelete = [field.name];
          if ((_field$spec = field.spec) !== null && _field$spec !== void 0 && (_field$spec$runtimeFi = _field$spec.runtimeField) !== null && _field$spec$runtimeFi !== void 0 && _field$spec$runtimeFi.fields) {
            const childFieldNames = Object.keys(field.spec.runtimeField.fields).map(key => `${field.name}.${key}`);
            toDelete.push(...childFieldNames);
          }
          deleteField(toDelete);
        },
        type: 'icon',
        'data-test-subj': 'deleteField',
        available: showDelete
      }],
      width: '80px'
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      tableCaption: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.table.tableCaption', {
        defaultMessage: 'Indexed fields'
      }),
      items: items,
      columns: columns,
      pagination: pagination,
      sorting: sorting,
      onTableChange: onTableChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 521,
        columnNumber: 7
      }
    });
  }
}
const TableWithoutPersist = exports.TableWithoutPersist = TableClass; // For testing purposes

const Table = exports.Table = (0, _sharedUxTablePersist.withEuiTablePersist)(TableClass, {
  tableId: 'dataViewsIndexedFields',
  pageSizeOptions: PAGE_SIZE_OPTIONS,
  initialSort: {
    field: 'displayName',
    direction: 'asc'
  },
  initialPageSize: 10
});