"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditFieldContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _breadcrumbs = require("../../breadcrumbs");
var _create_edit_field = require("./create_edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/create_edit_field/create_edit_field_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateEditFieldCont = ({
  ...props
}) => {
  const {
    setBreadcrumbs,
    dataViews
  } = (0, _public.useKibana)().services;
  const [indexPattern, setIndexPattern] = (0, _react.useState)();
  const fieldName = props.match.params.fieldName && decodeURIComponent(props.match.params.fieldName);
  (0, _react.useEffect)(() => {
    dataViews.get(props.match.params.id).then(ip => {
      setIndexPattern(ip);
      if (ip) {
        setBreadcrumbs(fieldName ? (0, _breadcrumbs.getEditFieldBreadcrumbs)(ip, fieldName) : (0, _breadcrumbs.getCreateFieldBreadcrumbs)(ip));
      }
    });
  }, [props.match.params.id, fieldName, setBreadcrumbs, dataViews]);
  if (indexPattern) {
    return /*#__PURE__*/_react.default.createElement(_create_edit_field.CreateEditField, {
      indexPattern: indexPattern,
      mode: fieldName ? 'edit' : 'create',
      fieldName: fieldName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
const CreateEditFieldContainer = exports.CreateEditFieldContainer = (0, _reactRouterDom.withRouter)(CreateEditFieldCont);