"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocInputIdValue = exports.DocumentsNavPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _state_utils = require("../../state_utils");
var _field_preview_context = require("./field_preview_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/preview/documents_nav_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const docIdSelector = state => {
  const doc = state.documents[state.currentIdx];
  return {
    documentId: doc ? doc._id : undefined,
    customId: state.customId
  };
};
const getDocInputIdValue = (customId, documentId) => {
  if (typeof customId === 'string') {
    return customId;
  }
  if (documentId) {
    return documentId;
  }
  return '';
};
exports.getDocInputIdValue = getDocInputIdValue;
const fetchDocErrorSelector = state => state.fetchDocError;
const DocumentsNavPreview = () => {
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const {
    goToPreviousDocument: prev,
    goToNextDocument: next
  } = controller;
  const {
    documentId,
    customId
  } = (0, _state_utils.useStateSelector)(controller.state$, docIdSelector);
  const fetchDocError = (0, _state_utils.useStateSelector)(controller.state$, fetchDocErrorSelector);
  const isInvalid = (fetchDocError === null || fetchDocError === void 0 ? void 0 : fetchDocError.code) === 'DOC_NOT_FOUND';

  // We don't display the nav button when the user has entered a custom
  // document ID as at that point there is no more reference to what's "next"
  const showNavButtons = !customId;
  const onDocumentIdChange = (0, _react.useCallback)(e => {
    const nextId = e.target.value;
    controller.setCustomDocIdToLoad(nextId);
  }, [controller]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentIdField.label', {
      defaultMessage: 'Document ID'
    }),
    isInvalid: isInvalid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid,
    value: getDocInputIdValue(customId, documentId),
    onChange: onDocumentIdChange,
    fullWidth: true,
    "data-test-subj": "documentIdField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })), customId && /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "xs",
    flush: "left",
    onClick: () => controller.fetchSampleDocuments(),
    "data-test-subj": "loadDocsFromClusterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentIdField.loadDocumentsFromCluster', {
    defaultMessage: 'Load documents from cluster'
  })))), showNavButtons && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "documentsNav",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "m",
    onClick: prev,
    iconType: "arrowLeft",
    "data-test-subj": "goToPrevDocButton",
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentNav.previousArialabel', {
      defaultMessage: 'Previous document'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "m",
    onClick: next,
    iconType: "arrowRight",
    "data-test-subj": "goToNextDocButton",
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.documentNav.nextArialabel', {
      defaultMessage: 'Next document'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }))))));
};
exports.DocumentsNavPreview = DocumentsNavPreview;