"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToUTCtime = exports.momentDateParser = exports.isDateRangeValid = exports.DEFAULT_DATE_RANGE_OPTIONS = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_RANGE_OPTIONS = exports.DEFAULT_DATE_RANGE_OPTIONS = Object.freeze({
  autoRefreshOptions: {
    enabled: false,
    duration: 10000
  },
  startDate: 'now-24h/h',
  endDate: 'now',
  maxDate: 'now+1s',
  minDate: 'now-9d',
  recentlyUsedDateRanges: []
});
const momentDateParser = date => _datemath.default.parse(date);
exports.momentDateParser = momentDateParser;
const transformToUTCtime = ({
  start,
  end,
  isISOString = false
}) => {
  var _momentDateParser$utc, _momentDateParser, _momentDateParser2, _momentDateParser3;
  const utcOffset = (_momentDateParser$utc = (_momentDateParser = momentDateParser(start)) === null || _momentDateParser === void 0 ? void 0 : _momentDateParser.utcOffset()) !== null && _momentDateParser$utc !== void 0 ? _momentDateParser$utc : 0;
  const utcStart = (_momentDateParser2 = momentDateParser(start)) === null || _momentDateParser2 === void 0 ? void 0 : _momentDateParser2.utc().add(utcOffset, 'm');
  const utcEnd = (_momentDateParser3 = momentDateParser(end)) === null || _momentDateParser3 === void 0 ? void 0 : _momentDateParser3.utc().add(utcOffset, 'm');
  return {
    start: isISOString ? utcStart === null || utcStart === void 0 ? void 0 : utcStart.toISOString() : momentDateParser(start),
    end: isISOString ? utcEnd === null || utcEnd === void 0 ? void 0 : utcEnd.toISOString() : momentDateParser(end)
  };
};
exports.transformToUTCtime = transformToUTCtime;
const isDateRangeValid = ({
  start,
  end
}) => {
  const startDate = momentDateParser(start);
  const endDate = momentDateParser(end);
  if (!startDate || !endDate) {
    return false;
  }
  const minDate = momentDateParser(DEFAULT_DATE_RANGE_OPTIONS.minDate);
  const maxDate = momentDateParser(DEFAULT_DATE_RANGE_OPTIONS.maxDate);
  return startDate.isSameOrAfter(minDate, 's') && endDate.isSameOrBefore(maxDate, 's') && startDate.isBefore(endDate, 's');
};
exports.isDateRangeValid = isDateRangeValid;