"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyDefaults = applyDefaults;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Do not change these defaults lightly... They applied to all data streams and may
 * result in a large number of updated data streams when this code is released.
 */
function applyDefaults(def) {
  const defaultDataStreamDefinition = {
    hidden: true,
    template: {
      priority: 100,
      _meta: {
        managed: true,
        userAgent: '@kbn/data-streams'
      },
      mappings: {
        dynamic: false
      },
      settings: {
        hidden: true
      }
    }
  };
  return (0, _lodash.defaultsDeep)(def, defaultDataStreamDefinition);
}