"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsaggs = getEsaggs;
exports.getFunctionDefinition = getFunctionDefinition;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _expressions = require("../../../common/search/expressions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Returns the expression function definition. Any stateful dependencies are accessed
 * at runtime via the `getStartDependencies` param, which provides the specific services
 * needed for this function to run.
 *
 * This function is an implementation detail of this module, and is exported separately
 * only for testing purposes.
 *
 * @param getStartDependencies - async function that resolves with EsaggsStartDependencies
 *
 * @internal
 */
function getFunctionDefinition({
  getStartDependencies
}) {
  return () => ({
    ...(0, _expressions.getEsaggsMeta)(),
    allowCache: {
      withSideEffects: (_, {
        inspectorAdapters
      }) => {
        return (0, _expressions.getSideEffectFunction)(inspectorAdapters);
      }
    },
    fn(input, args, {
      inspectorAdapters,
      abortSignal,
      getSearchSessionId,
      getExecutionContext,
      getSearchContext
    }) {
      return (0, _rxjs.defer)(async () => {
        var _args$aggs$map, _args$aggs;
        const [{
          aggs,
          dataViews,
          searchSource,
          getNow
        }, {
          handleEsaggsRequest
        }] = await Promise.all([getStartDependencies(), Promise.resolve().then(() => _interopRequireWildcard(require('../../../common/search/expressions')))]);
        const indexPattern = await dataViews.create(args.index.value, true);
        const aggConfigs = aggs.createAggConfigs(indexPattern, (_args$aggs$map = (_args$aggs = args.aggs) === null || _args$aggs === void 0 ? void 0 : _args$aggs.map(agg => agg.value)) !== null && _args$aggs$map !== void 0 ? _args$aggs$map : [], {
          hierarchical: args.metricsAtAllLevels,
          partialRows: args.partialRows,
          probability: args.probability,
          samplerSeed: args.samplerSeed
        });
        return {
          aggConfigs,
          indexPattern,
          searchSource,
          getNow,
          handleEsaggsRequest
        };
      }).pipe((0, _rxjs.switchMap)(({
        aggConfigs,
        indexPattern,
        searchSource,
        getNow,
        handleEsaggsRequest
      }) => {
        const {
          disableWarningToasts
        } = getSearchContext();
        return handleEsaggsRequest({
          abortSignal,
          aggs: aggConfigs,
          filters: args.ignoreGlobalFilters ? undefined : (0, _lodash.get)(input, 'filters', undefined),
          indexPattern,
          inspectorAdapters,
          query: args.ignoreGlobalFilters ? undefined : (0, _lodash.get)(input, 'query', undefined),
          searchSessionId: getSearchSessionId(),
          searchSourceService: searchSource,
          timeFields: args.timeFields,
          timeRange: (0, _lodash.get)(input, 'timeRange', undefined),
          disableWarningToasts: disableWarningToasts || false,
          getNow,
          executionContext: getExecutionContext(),
          projectRouting: (0, _lodash.get)(input, 'projectRouting', undefined)
        });
      }));
    }
  });
}

/**
 * This is some glue code that takes in `core.getStartServices`, extracts the dependencies
 * needed for this function, and wraps them behind a `getStartDependencies` function that
 * is then called at runtime.
 *
 * We do this so that we can be explicit about exactly which dependencies the function
 * requires, without cluttering up the top-level `plugin.ts` with this logic. It also
 * makes testing the expression function a bit easier since `getStartDependencies` is
 * the only thing you should need to mock.
 *
 * @param getStartServices - core's StartServicesAccessor for this plugin
 *
 * @internal
 */
function getEsaggs({
  getStartServices
}) {
  return getFunctionDefinition({
    getStartDependencies: async () => {
      const [, {
        dataViews
      }, self] = await getStartServices();
      const {
        search,
        nowProvider
      } = self;
      return {
        aggs: search.aggs,
        dataViews,
        searchSource: search.searchSource,
        getNow: () => nowProvider.get()
      };
    }
  });
}