"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _constants = require("./search/constants");
var _search_service = require("./search/search_service");
var _query = require("./query");
var _services = require("./services");
var _triggers = require("./triggers");
var _table_inspector_view = require("./utils/table_inspector_view");
var _now_provider = require("./now_provider");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class DataPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "searchService", void 0);
    (0, _defineProperty2.default)(this, "queryService", void 0);
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "nowProvider", void 0);
    this.searchService = new _search_service.SearchService(initializerContext);
    this.queryService = new _query.QueryService(initializerContext.config.get().query.timefilter.minRefreshInterval);
    this.storage = new _public.Storage(window.localStorage);
    this.nowProvider = new _now_provider.NowProvider();
  }
  setup(core, {
    expressions,
    uiActions,
    usageCollection,
    inspector,
    fieldFormats,
    management
  }) {
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    (0, _services.setTheme)(core.theme);
    const searchService = this.searchService.setup(core, {
      usageCollection,
      expressions,
      management,
      nowProvider: this.nowProvider
    });
    const queryService = this.queryService.setup({
      uiSettings: core.uiSettings,
      storage: this.storage,
      nowProvider: this.nowProvider
    });
    uiActions.registerTrigger(_triggers.applyFilterTrigger);
    inspector.registerView((0, _table_inspector_view.getTableViewDescription)(() => ({
      uiActions: startServices().plugins.uiActions,
      uiSettings: startServices().core.uiSettings,
      fieldFormats: startServices().self.fieldFormats,
      isFilterable: startServices().self.datatableUtilities.isFilterable
    })));
    fieldFormats.register((0, _common.getAggsFormats)(serializedFieldFormat => startServices().plugins.fieldFormats.deserialize(serializedFieldFormat)));
    core.analytics.registerEventType({
      eventType: _constants.EVENT_TYPE_DATA_SEARCH_TIMEOUT,
      schema: {
        [_constants.EVENT_PROPERTY_SEARCH_TIMEOUT_MS]: {
          type: 'long',
          _meta: {
            description: 'The time (in ms) before the search request was aborted due to timeout (search:timeout advanced setting)'
          }
        },
        [_constants.EVENT_PROPERTY_EXECUTION_CONTEXT]: {
          type: 'pass_through',
          _meta: {
            description: 'Execution context of the search request that timed out'
          }
        }
      }
    });
    return {
      search: searchService,
      query: queryService
    };
  }
  start(core, {
    uiActions,
    fieldFormats,
    dataViews,
    inspector,
    screenshotMode,
    share
  }) {
    const {
      uiSettings,
      overlays
    } = core;
    (0, _services.setOverlays)(overlays);
    (0, _services.setUiSettings)(uiSettings);
    (0, _services.setIndexPatterns)(dataViews);
    const query = this.queryService.start({
      storage: this.storage,
      http: core.http,
      uiSettings
    });
    const search = this.searchService.start(core, {
      fieldFormats,
      dataViews,
      inspector,
      screenshotMode,
      share,
      scriptedFieldsEnabled: dataViews.scriptedFieldsEnabled
    });
    (0, _services.setSearchService)(search);
    uiActions.addTriggerActionAsync('SELECT_RANGE_TRIGGER', 'ACTION_SELECT_RANGE', async () => {
      const {
        createSelectRangeActionDefinition
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
      const rangeSelectAction = createSelectRangeActionDefinition(() => ({
        uiActions
      }));
      return rangeSelectAction;
    });
    uiActions.addTriggerActionAsync('VALUE_CLICK_TRIGGER', 'ACTION_VALUE_CLICK', async () => {
      const {
        createValueClickActionDefinition
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
      const valueClickAction = createValueClickActionDefinition(() => ({
        uiActions
      }));
      return valueClickAction;
    });
    uiActions.addTriggerActionAsync('MULTI_VALUE_CLICK_TRIGGER', 'ACTION_MULTI_VALUE_CLICK', async () => {
      const {
        createMultiValueClickActionDefinition
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
      const multiValueClickAction = createMultiValueClickActionDefinition(() => ({
        query
      }));
      return multiValueClickAction;
    });
    const datatableUtilities = new _common.DatatableUtilitiesService(search.aggs, dataViews, fieldFormats);
    const dataServices = {
      actions: {
        createFiltersFromValueClickAction: async context => {
          const {
            createFiltersFromValueClickAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions/filters')));
          return createFiltersFromValueClickAction(context);
        },
        createFiltersFromRangeSelectAction: async context => {
          const {
            createFiltersFromRangeSelectAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions/filters')));
          return createFiltersFromRangeSelectAction(context);
        },
        createFiltersFromMultiValueClickAction: async context => {
          const {
            createFiltersFromMultiValueClickAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions/filters')));
          return createFiltersFromMultiValueClickAction(context);
        }
      },
      datatableUtilities,
      fieldFormats,
      dataViews,
      query,
      search,
      nowProvider: this.nowProvider
    };
    return dataServices;
  }
  stop() {
    this.queryService.stop();
    this.searchService.stop();
  }
}
exports.DataPublicPlugin = DataPublicPlugin;