"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pollSearch = void 0;
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-utils-plugin/common");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const pollSearch = (search, cancel, {
  pollInterval,
  abortSignal
} = {}) => {
  const getPollInterval = elapsedTime => {
    if (typeof pollInterval === 'number') return pollInterval;else {
      // if static pollInterval is not provided, then use default back-off logic
      switch (true) {
        case elapsedTime < 1500:
          return 300;
        case elapsedTime < 5000:
          return 1000;
        case elapsedTime < 20000:
          return 2500;
        default:
          return 5000;
      }
    }
  };
  return (0, _rxjs.defer)(() => {
    const startTime = Date.now();
    if (abortSignal !== null && abortSignal !== void 0 && abortSignal.aborted) {
      throw new _common.AbortError();
    }
    const safeCancel = () => cancel === null || cancel === void 0 ? void 0 : cancel().catch(e => {
      console.error(e); // eslint-disable-line no-console
    });
    if (cancel) {
      abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.addEventListener('abort', safeCancel, {
        once: true
      });
    }
    const aborted$ = (abortSignal ? (0, _rxjs.fromEvent)(abortSignal, 'abort') : _rxjs.EMPTY).pipe((0, _rxjs.switchMap)(e => (0, _rxjs.throwError)(() => {
      var _e$target;
      return new _common.AbortError((_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.reason);
    })));
    return (0, _rxjs.from)(search()).pipe((0, _rxjs.expand)(() => {
      const elapsedTime = Date.now() - startTime;
      return (0, _rxjs.timer)(getPollInterval(elapsedTime)).pipe((0, _rxjs.switchMap)(() => search()));
    }), (0, _rxjs.tap)(response => {
      if ((0, _.isAbortResponse)(response)) {
        throw new _common.AbortError();
      }
    }), (0, _rxjs.takeWhile)(_.isRunningResponse, true), (0, _rxjs.takeUntil)(aborted$));
  });
};
exports.pollSearch = pollSearch;