"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _v = require("./v1");
var _v2 = require("./v2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const stateSchemaByVersion = exports.stateSchemaByVersion = {
  1: _v.versionDefinition,
  2: _v2.versionDefinition
};
const latest = _v2.versionDefinition;
/**
 * WARNING: Do not modify the code below when doing a new version.
 * Update the "latest\" variable instead.
 */
const latestTaskStateSchema = latest.schema;
const emptyState = exports.emptyState = {
  runs: 0,
  telemetry: {
    panels: {
      total: 0,
      by_reference: 0,
      by_value: 0,
      by_type: {}
    },
    controls: {
      total: 0,
      chaining_system: {},
      ignore_settings: {},
      label_position: {},
      by_type: {}
    },
    sections: {
      total: 0
    },
    access_mode: {}
  }
};