"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.update = update;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _constants = require("../../../common/constants");
var _transforms = require("../transforms");
var _saved_object_utils = require("../saved_object_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function update(requestCtx, id, updateBody) {
  const {
    core
  } = await requestCtx.resolve(['core']);
  const {
    access_control: accessControl,
    ...restOfData
  } = updateBody.data;
  const {
    attributes: soAttributes,
    references: soReferences,
    error: transformInError
  } = (0, _transforms.transformDashboardIn)(restOfData);
  if (transformInError) {
    throw _boom.default.badRequest(`Invalid data. ${transformInError.message}`);
  }
  const savedObject = await core.savedObjects.client.update(_constants.DASHBOARD_SAVED_OBJECT_TYPE, id, soAttributes, {
    references: soReferences,
    /** perform a "full" update instead, where the provided attributes will fully replace the existing ones */
    mergeAttributes: false
  });
  return (0, _saved_object_utils.getDashboardCRUResponseBody)(savedObject, 'update');
}