"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformPanelsOut = transformPanelsOut;
var _kibana_services = require("../../../kibana_services");
var _get_panel_references = require("./get_panel_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformPanelsOut(panelsJSON = '[]', sections = [], containerReferences) {
  const topLevelPanels = [];
  const sectionsMap = {};
  sections.forEach(section => {
    const {
      gridData: grid,
      ...restOfSection
    } = section;
    const {
      i: sectionId,
      ...restOfGrid
    } = grid;
    sectionsMap[sectionId] = {
      ...restOfSection,
      grid: restOfGrid,
      panels: [],
      uid: sectionId
    };
  });
  JSON.parse(panelsJSON).forEach(panel => {
    const panelReferences = (0, _get_panel_references.getPanelReferences)(containerReferences !== null && containerReferences !== void 0 ? containerReferences : [], panel);
    const {
      sectionId
    } = panel.gridData;
    if (sectionId) {
      sectionsMap[sectionId].panels.push(transformPanelProperties(panel, panelReferences, containerReferences));
    } else {
      topLevelPanels.push(transformPanelProperties(panel, panelReferences, containerReferences));
    }
  });
  return [...topLevelPanels, ...Object.values(sectionsMap)];
}
function transformPanelProperties({
  embeddableConfig,
  gridData,
  id,
  panelIndex,
  panelRefName,
  title,
  type,
  version
}, panelReferences, containerReferences) {
  const {
    sectionId,
    i,
    ...restOfGrid
  } = gridData;
  const matchingReference = panelRefName && panelReferences ? panelReferences.find(reference => reference.name === panelRefName) : undefined;
  const storedSavedObjectId = id !== null && id !== void 0 ? id : embeddableConfig.savedObjectId;
  const savedObjectId = matchingReference ? matchingReference.id : storedSavedObjectId;
  const panelType = matchingReference ? matchingReference.type : type;
  const transforms = _kibana_services.embeddableService === null || _kibana_services.embeddableService === void 0 ? void 0 : _kibana_services.embeddableService.getTransforms(panelType);
  const config = {
    ...embeddableConfig,
    // <8.19 savedObjectId and title stored as siblings to embeddableConfig
    ...(savedObjectId !== undefined && {
      savedObjectId
    }),
    ...(title !== undefined && {
      title
    })
  };
  let transformedPanelConfig;
  try {
    if (transforms !== null && transforms !== void 0 && transforms.transformOut) {
      transformedPanelConfig = transforms.transformOut(config, panelReferences, containerReferences);
    }
  } catch (transformOutError) {
    // do not prevent read on transformOutError
    _kibana_services.logger.warn(`Unable to transform "${panelType}" embeddable state on read. Error: ${transformOutError.message}`);
  }
  return {
    grid: restOfGrid,
    config: transformedPanelConfig ? transformedPanelConfig : config,
    uid: panelIndex,
    type: panelType,
    ...(version && {
      version
    })
  };
}