"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformOptionsOut = transformOptionsOut;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const savedObjectToAPIOptionsKeys = {
  hidePanelTitles: 'hide_panel_titles',
  useMargins: 'use_margins',
  syncColors: 'sync_colors',
  syncTooltips: 'sync_tooltips',
  syncCursor: 'sync_cursor'
};
function transformOptionsOut(optionsJSON) {
  const options = JSON.parse(optionsJSON);
  const apiOptions = {};
  Object.keys(options).forEach(key => {
    const savedObjectKey = key;
    const apiKey = savedObjectToAPIOptionsKeys[savedObjectKey];
    if (apiKey) apiOptions[apiKey] = options[savedObjectKey];
  });
  return apiOptions;
}