"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.search = search;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _constants = require("../../../common/constants");
var _transforms = require("../transforms");
var _saved_object_utils = require("../saved_object_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function search(requestCtx, searchBody) {
  const {
    core
  } = await requestCtx.resolve(['core']);
  const soResponse = await core.savedObjects.client.find({
    type: _constants.DASHBOARD_SAVED_OBJECT_TYPE,
    searchFields: ['title^3', 'description'],
    fields: ['description', 'title',
    // required fields to load timeRange
    'timeFrom', 'timeTo', 'timeRestore'],
    search: searchBody.search,
    perPage: searchBody.per_page,
    page: searchBody.page ? +searchBody.page : undefined,
    defaultSearchOperator: 'AND',
    ...(0, _contentManagementUtils.tagsToFindOptions)(searchBody.tags)
  });
  return {
    dashboards: soResponse.saved_objects.map(so => {
      const {
        description,
        tags,
        time_range,
        title
      } = (0, _transforms.transformDashboardOut)(so.attributes, so.references);
      return {
        id: so.id,
        data: {
          ...(description && {
            description
          }),
          ...(tags && {
            tags
          }),
          ...(time_range && {
            time_range
          }),
          ...((so === null || so === void 0 ? void 0 : so.accessControl) && {
            access_control: {
              owner: so.accessControl.owner,
              access_mode: so.accessControl.accessMode
            }
          }),
          title: title !== null && title !== void 0 ? title : ''
        },
        meta: (0, _saved_object_utils.getDashboardMeta)(so, 'search')
      };
    }),
    page: soResponse.page,
    total: soResponse.total
  };
}