"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateRequestBodySchema = getCreateRequestBodySchema;
exports.getCreateResponseBodySchema = getCreateResponseBodySchema;
var _configSchema = require("@kbn/config-schema");
var _dashboard_state_schemas = require("../dashboard_state_schemas");
var _meta_schemas = require("../meta_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getCreateRequestBodySchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    data: (0, _dashboard_state_schemas.getDashboardStateSchema)(),
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1,
      maxSize: 1
    }))
  });
}
function getCreateResponseBodySchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    data: (0, _dashboard_state_schemas.getDashboardStateSchema)(),
    meta: _configSchema.schema.allOf([_meta_schemas.baseMetaSchema, _meta_schemas.createdMetaSchema, _meta_schemas.updatedMetaSchema]),
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  });
}