"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardRenderer = DashboardRenderer;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-utils-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _load_dashboard_api = require("../dashboard_api/load_dashboard_api");
var _use_dashboard_api = require("../dashboard_api/use_dashboard_api");
var _use_dashboard_internal_api = require("../dashboard_api/use_dashboard_internal_api");
var _kibana_services = require("../services/kibana_services");
var _dashboard_ = require("./dashboard_404");
var _dashboard_viewport = require("./viewport/dashboard_viewport");
var _print_styles = require("./print_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/dashboard_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DashboardRenderer({
  locator,
  savedObjectId,
  showPlainSpinner,
  dashboardRedirect,
  getCreationOptions,
  onApiAvailable
}) {
  const dashboardViewport = (0, _react.useRef)(null);
  const dashboardContainerRef = (0, _react.useRef)(null);
  const [dashboardApi, setDashboardApi] = (0, _react.useState)();
  const [dashboardInternalApi, setDashboardInternalApi] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    /* In case the locator prop changes, we need to reassign the value in the container */
    if (dashboardApi) dashboardApi.locator = locator;
  }, [dashboardApi, locator]);
  (0, _react.useEffect)(() => {
    if (dashboardInternalApi && dashboardInternalApi.dashboardContainerRef$.value !== dashboardContainerRef.current) {
      dashboardInternalApi.setDashboardContainerRef(dashboardContainerRef.current);
    }
  }, [dashboardInternalApi]);
  (0, _react.useEffect)(() => {
    if (error) setError(undefined);
    if (dashboardApi) setDashboardApi(undefined);
    if (dashboardInternalApi) setDashboardInternalApi(undefined);
    let canceled = false;
    let cleanupDashboardApi;
    (0, _load_dashboard_api.loadDashboardApi)({
      getCreationOptions,
      savedObjectId
    }).then(results => {
      if (!results) return;
      if (canceled) {
        results.cleanup();
        return;
      }
      cleanupDashboardApi = results.cleanup;
      setDashboardApi(results.api);
      setDashboardInternalApi(results.internalApi);
      onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(results.api);
    }).catch(err => {
      if (!canceled) setError(err);
    });
    return () => {
      var _cleanupDashboardApi;
      (_cleanupDashboardApi = cleanupDashboardApi) === null || _cleanupDashboardApi === void 0 ? void 0 : _cleanupDashboardApi();
      canceled = true;
    };
    // Disabling exhaustive deps because embeddable should only be created on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedObjectId]);
  const isDashboardViewportLoading = !dashboardApi && !error;
  const viewportClasses = (0, _classnames.default)('dashboardViewport', {
    'dashboardViewport--screenshotMode': _kibana_services.screenshotModeService.isScreenshotMode()
  }, {
    'dashboardViewport--loading': isDashboardViewportLoading
  });
  const loadingSpinner = showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  });
  const renderDashboardContents = () => {
    if (error) {
      return error instanceof _common.SavedObjectNotFound ? /*#__PURE__*/_react.default.createElement(_dashboard_.Dashboard404Page, {
        dashboardRedirect: dashboardRedirect,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 9
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "error",
        iconColor: "danger",
        title: /*#__PURE__*/_react.default.createElement("h2", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('dashboard.dashboardRenderer.loadDashboardErrorTitle', {
          defaultMessage: 'Unable to load dashboard'
        })),
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 17
          }
        }, error.message),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 9
        }
      });
    }
    return dashboardApi && dashboardInternalApi ? /*#__PURE__*/_react.default.createElement("div", {
      className: "dashboardContainer",
      "data-test-subj": "dashboardContainer",
      css: styles.renderer,
      ref: e => {
        if (dashboardInternalApi && dashboardInternalApi.dashboardContainerRef$.value !== e) {
          dashboardInternalApi.setDashboardContainerRef(e);
        }
        dashboardContainerRef.current = e;
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_print_styles.GlobalPrintStyles, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButtonKibanaProvider, {
      coreStart: {
        chrome: _kibana_services.coreServices.chrome,
        customBranding: _kibana_services.coreServices.customBranding
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_use_dashboard_api.DashboardContext.Provider, {
      value: dashboardApi,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_use_dashboard_internal_api.DashboardInternalContext.Provider, {
      value: dashboardInternalApi,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_dashboard_viewport.DashboardViewport, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }))))) : loadingSpinner;
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: dashboardViewport,
    className: viewportClasses,
    css: styles.renderer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, (dashboardViewport === null || dashboardViewport === void 0 ? void 0 : dashboardViewport.current) && dashboardApi && /*#__PURE__*/_react.default.createElement(ParentClassController, {
    viewportRef: dashboardViewport.current,
    dashboardApi: dashboardApi,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }), renderDashboardContents());
}
const styles = {
  renderer: (0, _react2.css)({
    display: 'flex',
    flex: 'auto',
    width: '100%',
    '&.dashboardViewport--loading': {
      justifyContent: 'center',
      alignItems: 'center'
    }
  })
};

/**
 * Maximizing a panel in Dashboard only works if the parent div has a certain class. This
 * small component listens to the Dashboard's expandedPanelId state and adds and removes
 * the class to whichever element renders the Dashboard.
 */
const ParentClassController = ({
  dashboardApi,
  viewportRef
}) => {
  const maximizedPanelId = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.expandedPanelId$);
  (0, _react.useLayoutEffect)(() => {
    const parentDiv = viewportRef.parentElement;
    if (!parentDiv) return;
    if (maximizedPanelId) {
      parentDiv.classList.add('dshDashboardViewportWrapper');
    } else {
      parentDiv.classList.remove('dshDashboardViewportWrapper');
    }
  }, [maximizedPanelId, viewportRef.parentElement]);
  return null;
};