"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchAction = void 0;
var _dashboard_client = require("./dashboard_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// temporary escape hatch to avoid circular dependencies
// use findDashboardService if possible
const searchAction = exports.searchAction = {
  id: 'searchDashboardAction',
  execute: async context => {
    const searchResults = await _dashboard_client.dashboardClient.search(context.search);
    context.onResults(searchResults.dashboards.map(({
      id,
      data,
      meta
    }) => ({
      id,
      isManaged: Boolean(meta.managed),
      title: data.title
    })));
  }
};