"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardMenuItems = void 0;
var _react = require("react");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _access_control_service = require("../../services/access_control_service");
var _constants = require("../../../common/constants");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _confirm_overlays = require("../../dashboard_listing/confirm_overlays");
var _open_settings_flyout = require("../../dashboard_renderer/settings/open_settings_flyout");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _kibana_services = require("../../services/kibana_services");
var _get_dashboard_capabilities = require("../../utils/get_dashboard_capabilities");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _show_add_menu = require("./add_menu/show_add_menu");
var _show_share_modal = require("./share/show_share_modal");
var _show_save_menu = require("./save_menu/show_save_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useDashboardMenuItems = ({
  isLabsShown,
  setIsLabsShown,
  maybeRedirect,
  showResetChange
}) => {
  const isMounted = (0, _useMountedState.default)();
  const accessControlClient = (0, _access_control_service.getAccessControlClient)();
  const appId = (0, _useObservable.default)(_kibana_services.coreServices.application.currentAppId$);
  const [isSaveInProgress, setIsSaveInProgress] = (0, _react.useState)(false);
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [dashboardTitle, hasOverlays, hasUnsavedChanges, lastSavedId, viewMode, accessControl] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.title$, dashboardApi.hasOverlays$, dashboardApi.hasUnsavedChanges$, dashboardApi.savedObjectId$, dashboardApi.viewMode$, dashboardApi.accessControl$);
  const disableTopNav = isSaveInProgress || hasOverlays;
  const isInEditAccessMode = accessControlClient.isInEditAccessMode(accessControl);
  const canManageAccessControl = (0, _react.useMemo)(() => {
    var _dashboardApi$user, _dashboardApi$user2;
    const userAccessControl = accessControlClient.checkUserAccessControl({
      accessControl,
      createdBy: dashboardApi.createdBy,
      userId: (_dashboardApi$user = dashboardApi.user) === null || _dashboardApi$user === void 0 ? void 0 : _dashboardApi$user.uid
    });
    return (dashboardApi === null || dashboardApi === void 0 ? void 0 : (_dashboardApi$user2 = dashboardApi.user) === null || _dashboardApi$user2 === void 0 ? void 0 : _dashboardApi$user2.hasGlobalAccessControlPrivilege) || userAccessControl;
  }, [accessControl, accessControlClient, dashboardApi.createdBy, dashboardApi.user]);
  const isCreatingNewDashboard = viewMode === 'edit' && !lastSavedId;
  const isEditButtonDisabled = (0, _react.useMemo)(() => {
    if (disableTopNav) return true;
    if (canManageAccessControl) return false;
    return !isInEditAccessMode;
  }, [disableTopNav, isInEditAccessMode, canManageAccessControl]);

  /**
   * Show the dashboard's "Confirm reset changes" modal. If confirmed:
   * (1) reset the dashboard to the last saved state, and
   * (2) if `switchToViewMode` is `true`, set the dashboard to view mode.
   */
  const [isResetting, setIsResetting] = (0, _react.useState)(false);
  const isQuickSaveButtonDisabled = (0, _react.useMemo)(() => {
    if (disableTopNav || isResetting) return true;
    if (dashboardApi.isAccessControlEnabled) {
      if (canManageAccessControl) return false;
      return !isInEditAccessMode;
    }
    return false;
  }, [canManageAccessControl, isInEditAccessMode, isResetting, dashboardApi.isAccessControlEnabled, disableTopNav]);
  const resetChanges = (0, _react.useCallback)((switchToViewMode = false) => {
    dashboardApi.clearOverlays();
    const switchModes = switchToViewMode ? () => {
      dashboardApi.setViewMode('view');
      (0, _dashboard_backup_service.getDashboardBackupService)().storeViewMode('view');
    } : undefined;
    if (!hasUnsavedChanges) {
      switchModes === null || switchModes === void 0 ? void 0 : switchModes();
      return;
    }
    (0, _confirm_overlays.confirmDiscardUnsavedChanges)(async () => {
      setIsResetting(true);
      await dashboardApi.asyncResetToLastSavedState();
      if (isMounted()) {
        setIsResetting(false);
        switchModes === null || switchModes === void 0 ? void 0 : switchModes();
      }
    }, viewMode);
  }, [dashboardApi, hasUnsavedChanges, viewMode, isMounted]);

  /**
   * initiate interactive dashboard copy action
   */
  const dashboardInteractiveSave = (0, _react.useCallback)(async () => {
    const result = await dashboardApi.runInteractiveSave();
    maybeRedirect(result);
    if (result && !result.error) {
      return result;
    }
  }, [maybeRedirect, dashboardApi]);

  /**
   * Save the dashboard without any UI or popups.
   */
  const quickSaveDashboard = (0, _react.useCallback)(() => {
    setIsSaveInProgress(true);
    dashboardApi.runQuickSave().then(() => setTimeout(() => {
      setIsSaveInProgress(false);
    }, 100));
  }, [dashboardApi]);
  const saveFromShareModal = (0, _react.useCallback)(async () => {
    if (lastSavedId) {
      quickSaveDashboard();
    } else {
      dashboardInteractiveSave();
    }
  }, [quickSaveDashboard, dashboardInteractiveSave, lastSavedId]);

  /**
   * Show the Dashboard app's share menu
   */
  const showShare = (0, _react.useCallback)((anchorElement, asExport) => {
    (0, _show_share_modal.ShowShareModal)({
      asExport,
      dashboardTitle,
      anchorElement,
      savedObjectId: lastSavedId,
      isDirty: Boolean(hasUnsavedChanges),
      canSave: (canManageAccessControl || isInEditAccessMode) && Boolean(hasUnsavedChanges),
      accessControl,
      createdBy: dashboardApi.createdBy,
      isManaged: dashboardApi.isManaged,
      accessControlClient,
      saveDashboard: saveFromShareModal,
      changeAccessMode: dashboardApi.changeAccessMode
    });
  }, [dashboardTitle, hasUnsavedChanges, lastSavedId, isInEditAccessMode, canManageAccessControl, accessControl, saveFromShareModal, dashboardApi.changeAccessMode, dashboardApi.createdBy, accessControlClient, dashboardApi.isManaged]);
  const getEditTooltip = (0, _react.useCallback)(() => {
    if (dashboardApi.isManaged) {
      return _dashboard_app_strings.topNavStrings.edit.managedDashboardTooltip;
    }
    if (isInEditAccessMode || canManageAccessControl) {
      return undefined;
    }
    return _dashboard_app_strings.topNavStrings.edit.writeRestrictedTooltip;
  }, [isInEditAccessMode, canManageAccessControl, dashboardApi.isManaged]);
  const getShareTooltip = (0, _react.useCallback)(() => {
    if (!dashboardApi.isAccessControlEnabled) return undefined;
    return isInEditAccessMode ? _dashboard_app_strings.topNavStrings.share.editModeTooltipContent : _dashboard_app_strings.topNavStrings.share.writeRestrictedModeTooltipContent;
  }, [isInEditAccessMode, dashboardApi.isAccessControlEnabled]);

  /**
   * Register all of the top nav configs that can be used by dashboard.
   */

  const menuItems = (0, _react.useMemo)(() => {
    return {
      fullScreen: {
        ..._dashboard_app_strings.topNavStrings.fullScreen,
        id: 'full-screen',
        testId: 'dashboardFullScreenMode',
        run: () => dashboardApi.setFullScreenMode(true),
        disableButton: disableTopNav
      },
      labs: {
        ..._dashboard_app_strings.topNavStrings.labs,
        id: 'labs',
        testId: 'dashboardLabs',
        run: () => setIsLabsShown(!isLabsShown)
      },
      edit: {
        ..._dashboard_app_strings.topNavStrings.edit,
        emphasize: true,
        id: 'edit',
        iconType: 'pencil',
        testId: 'dashboardEditMode',
        className: 'eui-hideFor--s eui-hideFor--xs',
        // hide for small screens - editing doesn't work in mobile mode.
        run: () => {
          (0, _dashboard_backup_service.getDashboardBackupService)().storeViewMode('edit');
          dashboardApi.setViewMode('edit');
          dashboardApi.clearOverlays();
        },
        disableButton: isEditButtonDisabled,
        tooltip: getEditTooltip()
      },
      quickSave: {
        ..._dashboard_app_strings.topNavStrings.quickSave,
        id: 'quick-save',
        iconType: 'save',
        emphasize: true,
        fill: true,
        testId: 'dashboardQuickSaveMenuItem',
        disableButton: isQuickSaveButtonDisabled,
        run: () => quickSaveDashboard(),
        splitButtonProps: {
          run: anchorElement => {
            (0, _show_save_menu.showSaveMenu)({
              dashboardApi,
              anchorElement,
              resetChanges,
              isResetting,
              isSaveInProgress,
              dashboardInteractiveSave,
              coreServices: _kibana_services.coreServices
            });
          },
          isMainButtonLoading: isSaveInProgress,
          isMainButtonDisabled: !hasUnsavedChanges,
          secondaryButtonAriaLabel: _dashboard_app_strings.topNavStrings.saveMenu.label,
          secondaryButtonIcon: 'arrowDown',
          secondaryButtonFill: true,
          isSecondaryButtonDisabled: isSaveInProgress
        }
      },
      interactiveSave: {
        disableButton: disableTopNav,
        emphasize: isCreatingNewDashboard,
        id: 'interactive-save',
        testId: 'dashboardInteractiveSaveMenuItem',
        iconType: lastSavedId ? undefined : 'save',
        run: dashboardInteractiveSave,
        label: isCreatingNewDashboard ? _dashboard_app_strings.topNavStrings.quickSave.label : _dashboard_app_strings.topNavStrings.viewModeInteractiveSave.label,
        description: viewMode === 'view' ? _dashboard_app_strings.topNavStrings.viewModeInteractiveSave.description : _dashboard_app_strings.topNavStrings.editModeInteractiveSave.description
      },
      switchToViewMode: {
        ..._dashboard_app_strings.topNavStrings.switchToViewMode,
        id: 'cancel',
        disableButton: disableTopNav || !lastSavedId || isResetting,
        isLoading: isResetting,
        testId: 'dashboardViewOnlyMode',
        run: () => resetChanges(true)
      },
      backgroundSearch: {
        ..._dashboard_app_strings.topNavStrings.backgroundSearch,
        id: 'backgroundSearch',
        iconType: 'backgroundTask',
        iconOnly: true,
        testId: 'openBackgroundSearchFlyoutButton',
        run: () => _kibana_services.dataService.search.showSearchSessionsFlyout({
          appId: appId,
          trackingProps: {
            openedFrom: 'background search button'
          }
        })
      },
      share: {
        ..._dashboard_app_strings.topNavStrings.share,
        id: 'share',
        iconType: 'share',
        iconOnly: true,
        testId: 'shareTopNavButton',
        disableButton: disableTopNav,
        run: showShare,
        tooltip: getShareTooltip()
      },
      export: {
        ..._dashboard_app_strings.topNavStrings.export,
        id: 'export',
        iconType: 'download',
        iconOnly: true,
        testId: 'exportTopNavButton',
        disableButton: disableTopNav,
        run: anchorElement => showShare(anchorElement, true)
      },
      settings: {
        ..._dashboard_app_strings.topNavStrings.settings,
        id: 'settings',
        testId: 'dashboardSettingsButton',
        disableButton: disableTopNav,
        htmlId: 'dashboardSettingsButton',
        run: () => (0, _open_settings_flyout.openSettingsFlyout)(dashboardApi)
      },
      add: {
        ..._dashboard_app_strings.topNavStrings.add,
        id: 'add',
        iconType: 'plusInCircle',
        color: 'success',
        fill: false,
        emphasize: true,
        type: 'button',
        testId: 'dashboardAddTopNavButton',
        htmlId: 'dashboardAddTopNavButton',
        disableButton: disableTopNav,
        run: anchorElement => (0, _show_add_menu.showAddMenu)({
          dashboardApi,
          anchorElement,
          coreServices: _kibana_services.coreServices
        })
      }
    };
  }, [disableTopNav, isSaveInProgress, isCreatingNewDashboard, lastSavedId, dashboardInteractiveSave, viewMode, showShare, dashboardApi, setIsLabsShown, isLabsShown, quickSaveDashboard, resetChanges, isResetting, isEditButtonDisabled, getEditTooltip, getShareTooltip, appId, isQuickSaveButtonDisabled, hasUnsavedChanges]);
  const resetChangesMenuItem = (0, _react.useMemo)(() => {
    return {
      ..._dashboard_app_strings.topNavStrings.resetChanges,
      id: 'reset',
      testId: 'dashboardDiscardChangesMenuItem',
      disableButton: isResetting || !hasUnsavedChanges || hasOverlays || viewMode === 'edit' && (isSaveInProgress || !lastSavedId),
      isLoading: isResetting,
      run: () => resetChanges()
    };
  }, [hasOverlays, lastSavedId, resetChanges, viewMode, isSaveInProgress, hasUnsavedChanges, isResetting]);

  /**
   * Build ordered menus for view and edit mode.
   */
  const isLabsEnabled = (0, _react.useMemo)(() => _kibana_services.coreServices.uiSettings.get(_constants.UI_SETTINGS.ENABLE_LABS_UI), []);
  const hasExportIntegration = (0, _react.useMemo)(() => {
    if (!_kibana_services.shareService) return false;
    return _kibana_services.shareService.availableIntegrations('dashboard', 'export').length > 0;
  }, []);
  const viewModeTopNavConfig = (0, _react.useMemo)(() => {
    const {
      showWriteControls,
      storeSearchSession
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    const labsMenuItem = isLabsEnabled ? [menuItems.labs] : [];
    const shareMenuItem = _kibana_services.shareService ? [
    // Only show the export button if the current user meets the requirements for at least one registered export integration
    hasExportIntegration ? menuItems.export : null, menuItems.share].filter(Boolean) : [];
    const duplicateMenuItem = showWriteControls ? [menuItems.interactiveSave] : [];
    const editMenuItem = showWriteControls && !dashboardApi.isManaged ? [menuItems.edit] : [];
    const mayberesetChangesMenuItem = showResetChange ? [resetChangesMenuItem] : [];
    const backgroundSearch = storeSearchSession && _kibana_services.dataService.search.isBackgroundSearchEnabled ? [menuItems.backgroundSearch] : [];
    return [...labsMenuItem, menuItems.fullScreen, ...duplicateMenuItem, ...mayberesetChangesMenuItem, ...backgroundSearch, ...shareMenuItem, ...editMenuItem];
  }, [isLabsEnabled, menuItems.labs, menuItems.export, menuItems.share, menuItems.interactiveSave, menuItems.edit, menuItems.fullScreen, menuItems.backgroundSearch, hasExportIntegration, dashboardApi.isManaged, showResetChange, resetChangesMenuItem]);
  const editModeTopNavConfig = (0, _react.useMemo)(() => {
    const {
      storeSearchSession
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    const labsMenuItem = isLabsEnabled ? [menuItems.labs] : [];
    const shareMenuItem = _kibana_services.shareService ? [
    // Only show the export button if the current user meets the requirements for at least one registered export integration
    hasExportIntegration ? menuItems.export : null, menuItems.share].filter(Boolean) : [];
    const editModeItems = [];
    if (lastSavedId) {
      editModeItems.push(menuItems.switchToViewMode);
      editModeItems.push(menuItems.add, menuItems.quickSave);
    } else {
      editModeItems.push(menuItems.switchToViewMode, menuItems.add, menuItems.interactiveSave);
    }
    const editModeTopNavConfigItems = [...labsMenuItem, menuItems.settings, ...editModeItems];
    const backgroundSearch = storeSearchSession && _kibana_services.dataService.search.isBackgroundSearchEnabled ? [menuItems.backgroundSearch] : [];

    // insert share menu item before the last item in edit mode
    editModeTopNavConfigItems.splice(-2, 0, ...backgroundSearch, ...shareMenuItem);
    return editModeTopNavConfigItems;
  }, [isLabsEnabled, menuItems.labs, menuItems.export, menuItems.share, menuItems.settings, menuItems.interactiveSave, menuItems.switchToViewMode, menuItems.quickSave, menuItems.add, menuItems.backgroundSearch, hasExportIntegration, lastSavedId]);
  return {
    viewModeTopNavConfig,
    editModeTopNavConfig
  };
};
exports.useDashboardMenuItems = useDashboardMenuItems;