"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowShareModal = ShowShareModal;
exports.showPublicUrlSwitch = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _contentManagementAccessControlPublic = require("@kbn/content-management-access-control-public");
var _constants = require("@kbn/deeplinks-analytics/constants");
var _dashboard_backup_service = require("../../../services/dashboard_backup_service");
var _kibana_services = require("../../../services/kibana_services");
var _get_dashboard_capabilities = require("../../../utils/get_dashboard_capabilities");
var _urls = require("../../../utils/urls");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _dashboard_router = require("../../dashboard_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/top_nav/share/show_share_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showFilterBarId = 'showFilterBar';
const showPublicUrlSwitch = anonymousUserCapabilities => {
  if (!anonymousUserCapabilities.dashboard_v2) return false;
  const dashboard = anonymousUserCapabilities.dashboard_v2;
  return !!dashboard.show;
};
exports.showPublicUrlSwitch = showPublicUrlSwitch;
function ShowShareModal({
  isDirty,
  asExport,
  anchorElement,
  savedObjectId,
  dashboardTitle,
  canSave,
  accessControl,
  createdBy,
  isManaged,
  accessControlClient,
  saveDashboard,
  changeAccessMode
}) {
  var _getDashboardBackupSe, _g2;
  if (!_kibana_services.shareService) return;
  const handleChangeAccessMode = async accessMode => {
    if (!savedObjectId) return;
    try {
      await changeAccessMode(accessMode);
      return _dashboard_app_strings.shareModalStrings.accessModeUpdateSuccess;
    } catch (error) {
      return _dashboard_app_strings.shareModalStrings.accessModeUpdateError;
    }
  };
  const EmbedUrlParamExtension = ({
    setParamValue
  }) => {
    const [urlParamsSelectedMap, seturlParamsSelectedMap] = (0, _react.useState)({
      showFilterBar: true
    });
    const checkboxes = [{
      id: _dashboard_router.dashboardUrlParams.showTopMenu,
      label: _dashboard_app_strings.shareModalStrings.getTopMenuCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showTimeFilter,
      label: _dashboard_app_strings.shareModalStrings.getTimeFilterCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showQueryInput,
      label: _dashboard_app_strings.shareModalStrings.getQueryCheckbox()
    }, {
      id: showFilterBarId,
      label: _dashboard_app_strings.shareModalStrings.getFilterBarCheckbox()
    }];
    const handleChange = param => {
      const newSelectedMap = {
        ...urlParamsSelectedMap,
        [param]: !urlParamsSelectedMap[param]
      };
      const urlParamValues = {
        [_dashboard_router.dashboardUrlParams.showTopMenu]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTopMenu],
        [_dashboard_router.dashboardUrlParams.showQueryInput]: newSelectedMap[_dashboard_router.dashboardUrlParams.showQueryInput],
        [_dashboard_router.dashboardUrlParams.showTimeFilter]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTimeFilter],
        [_dashboard_router.dashboardUrlParams.hideFilterBar]: !newSelectedMap[showFilterBarId]
      };
      seturlParamsSelectedMap(newSelectedMap);
      setParamValue(urlParamValues);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
      legend: {
        children: _dashboard_app_strings.shareModalStrings.getCheckboxLegend()
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 2,
      gutterSize: "s",
      "data-test-subj": "embedUrlParamExtension",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }, checkboxes.map(({
      id,
      label
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: id,
      label: label,
      checked: !!urlParamsSelectedMap[id],
      onChange: () => handleChange(id),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    })))));
  };
  const unsavedDashboardState = (_getDashboardBackupSe = (0, _dashboard_backup_service.getDashboardBackupService)().getState(savedObjectId)) !== null && _getDashboardBackupSe !== void 0 ? _getDashboardBackupSe : {};
  const hasPanelChanges = unsavedDashboardState.panels !== undefined;
  const unsavedDashboardStateForLocator = {
    ...unsavedDashboardState,
    controlGroupInput: unsavedDashboardState.controlGroupInput,
    references: unsavedDashboardState.references
  };
  const locatorParams = {
    dashboardId: savedObjectId,
    preserveSavedFilters: true,
    refresh_interval: undefined,
    // We don't share refresh interval externally
    viewMode: 'view',
    // For share locators we always load the dashboard in view mode
    useHash: false,
    time_range: _kibana_services.dataService.query.timefilter.timefilter.getTime(),
    ...unsavedDashboardStateForLocator
  };
  let _g = (0, _public.getStateFromKbnUrl)('_g', window.location.href);
  if ((_g2 = _g) !== null && _g2 !== void 0 && _g2.filters && _g.filters.length === 0) {
    _g = (0, _lodash.omit)(_g, 'filters');
  }
  const baseUrl = (0, _public.setStateToKbnUrl)('_g', _g, undefined, window.location.href);
  const shareableUrl = (0, _public.setStateToKbnUrl)(_urls.DASHBOARD_STATE_STORAGE_KEY, unsavedDashboardStateForLocator, {
    useHash: false,
    storeInHashQuery: true
  }, (0, _public.unhashUrl)(baseUrl));
  const {
    createShortUrl,
    showWriteControls
  } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
  const allowShortUrl = createShortUrl;
  const showAccessContainer = savedObjectId && !isManaged && showWriteControls;
  _kibana_services.shareService.toggleShareContextMenu({
    isDirty,
    anchorElement,
    allowShortUrl,
    shareableUrl,
    asExport,
    objectId: savedObjectId,
    objectType: 'dashboard',
    onSave: canSave ? saveDashboard : undefined,
    objectTypeMeta: {
      title: _i18n.i18n.translate('dashboard.share.shareModal.title', {
        defaultMessage: 'Share dashboard'
      }),
      config: {
        link: {
          draftModeCallOut: {
            message: hasPanelChanges ? allowShortUrl ? _dashboard_app_strings.shareModalStrings.getDraftSharePanelChangesWarning() : _dashboard_app_strings.shareModalStrings.getSnapshotShareWarning() : _dashboard_app_strings.shareModalStrings.getDraftShareWarning('link'),
            'data-test-subj': 'DashboardDraftModeCopyLinkCallOut'
          }
        },
        embed: {
          draftModeCallOut: {
            message: hasPanelChanges ? _dashboard_app_strings.shareModalStrings.getEmbedSharePanelChangesWarning() : _dashboard_app_strings.shareModalStrings.getDraftShareWarning('embed'),
            'data-test-subj': 'DashboardDraftModeEmbedCallOut'
          },
          embedUrlParamExtensions: [{
            paramName: 'embed',
            component: EmbedUrlParamExtension
          }],
          computeAnonymousCapabilities: showPublicUrlSwitch
        },
        integration: {
          export: {
            pdfReports: {
              draftModeCallOut: true
            },
            imageReports: {
              draftModeCallOut: true
            }
          }
        }
      }
    },
    sharingData: {
      title: dashboardTitle || _i18n.i18n.translate('dashboard.share.defaultDashboardTitle', {
        defaultMessage: 'Dashboard [{date}]',
        values: {
          date: (0, _moment.default)().toISOString(true)
        }
      }),
      locatorParams: {
        id: _deeplinksAnalytics.DASHBOARD_APP_LOCATOR,
        params: locatorParams
      },
      accessModeContainer: showAccessContainer ? /*#__PURE__*/_react.default.createElement(_contentManagementAccessControlPublic.AccessModeContainer, {
        accessControl: accessControl,
        createdBy: createdBy,
        getActiveSpace: _kibana_services.spacesService === null || _kibana_services.spacesService === void 0 ? void 0 : _kibana_services.spacesService.getActiveSpace,
        getCurrentUser: _kibana_services.coreServices.userProfile.getCurrent,
        onChangeAccessMode: handleChangeAccessMode,
        accessControlClient: accessControlClient,
        contentTypeId: _constants.DASHBOARD_SAVED_OBJECT_TYPE,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 9
        }
      }) : undefined
    },
    shareableUrlLocatorParams: {
      locator: _kibana_services.shareService.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR),
      params: {
        ...locatorParams,
        timeRange: locatorParams.time_range
      }
    }
  });
}