"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndicesList = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../../constants");
var _selectors = require("../../../store/selectors");
var _actions = require("../../../store/actions");
var _follower_indices_list = require("./follower_indices_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.FOLLOWER_INDEX;
const mapStateToProps = state => ({
  followerIndices: (0, _selectors.getListFollowerIndices)(state),
  followerIndexId: (0, _selectors.getSelectedFollowerIndexId)('detail')(state),
  apiStatus: (0, _selectors.getApiStatus)(scope)(state),
  apiError: (0, _selectors.getApiError)(scope)(state),
  isAuthorized: (0, _selectors.isApiAuthorized)(scope)(state)
});
const mapDispatchToProps = dispatch => ({
  loadFollowerIndices: inBackground => dispatch((0, _actions.loadFollowerIndices)(inBackground)),
  selectFollowerIndex: id => dispatch((0, _actions.selectDetailFollowerIndex)(id))
});
const FollowerIndicesList = exports.FollowerIndicesList = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_follower_indices_list.FollowerIndicesList);