"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProjectRoutingAccess = exports.ACCESS_CONTROL_CONFIG = void 0;
var _cpsUtils = require("@kbn/cps-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Rule for determining access based on route pattern
 */

/**
 * Configuration for a single app's access control
 */

/**
 * Complete access control configuration
 * Maps app IDs to their access configurations
 */

/**
 * Default access control configuration
 *
 * Access Levels:
 * - EDITABLE: Full functionality - users can change project scope
 * - READONLY: View-only mode - shows current scope but prevents changes
 * - DISABLED: Picker is completely disabled
 *
 */
const ACCESS_CONTROL_CONFIG = exports.ACCESS_CONTROL_CONFIG = {
  dashboards: {
    defaultAccess: _cpsUtils.ProjectRoutingAccess.EDITABLE,
    routeRules: [{
      pattern: /#\/list/,
      access: _cpsUtils.ProjectRoutingAccess.DISABLED
    }]
  },
  discover: {
    defaultAccess: _cpsUtils.ProjectRoutingAccess.EDITABLE
  },
  visualize: {
    defaultAccess: _cpsUtils.ProjectRoutingAccess.DISABLED,
    routeRules: [{
      pattern: /type:vega/,
      // Restrict to only Vega visualizations
      access: _cpsUtils.ProjectRoutingAccess.EDITABLE
    }]
  },
  lens: {
    defaultAccess: _cpsUtils.ProjectRoutingAccess.EDITABLE
  },
  maps: {
    defaultAccess: _cpsUtils.ProjectRoutingAccess.EDITABLE
  }
};

/**
 * Determines project routing access level based on app and route
 */
const getProjectRoutingAccess = (currentAppId, hash) => {
  const appConfig = ACCESS_CONTROL_CONFIG[currentAppId];
  if (!appConfig) {
    return _cpsUtils.ProjectRoutingAccess.DISABLED;
  }
  if (appConfig.routeRules) {
    for (const rule of appConfig.routeRules) {
      if (rule.pattern.test(hash)) {
        return rule.access;
      }
    }
  }
  return appConfig.defaultAccess;
};
exports.getProjectRoutingAccess = getProjectRoutingAccess;