"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnnouncementsSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getAnnouncementsSettings = () => {
  return {
    hideAnnouncements: {
      name: _i18n.i18n.translate('core.ui_settings.params.hideAnnouncements', {
        defaultMessage: 'Hide announcements'
      }),
      value: false,
      description: _i18n.i18n.translate('core.ui_settings.params.hideAnnouncementsText', {
        defaultMessage: 'Stop showing messages and tours that highlight new features.'
      }),
      schema: _configSchema.schema.boolean()
    }
  };
};
exports.getAnnouncementsSettings = getAnnouncementsSettings;