"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreVersionedRoute = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreHttpCommon = require("@kbn/core-http-common");
var _route_version_utils = require("./route_version_utils");
var _util = require("../util");
var _security_route_config_validator = require("../security_route_config_validator");
var _handler_resolvers = require("./handler_resolvers");
var _util2 = require("./util");
var _response = require("../response");
var _route = require("../route");
var _validator = require("../validator");
var _get_warning_header_message = require("../get_warning_header_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function extractValidationSchemaFromHandler(handler) {
  if (handler.options.validate === false) return undefined;
  if (typeof handler.options.validate === 'function') return handler.options.validate();
  return handler.options.validate;
}
class CoreVersionedRoute {
  static from({
    router,
    log,
    method,
    path,
    options
  }) {
    return new CoreVersionedRoute(router, log, method, path, options);
  }
  constructor(router, log, method, path, internalOptions) {
    (0, _defineProperty2.default)(this, "handlers", new Map());
    (0, _defineProperty2.default)(this, "options", void 0);
    (0, _defineProperty2.default)(this, "useDefaultStrategyForPath", void 0);
    (0, _defineProperty2.default)(this, "isPublic", void 0);
    (0, _defineProperty2.default)(this, "env", void 0);
    (0, _defineProperty2.default)(this, "enableQueryVersion", void 0);
    (0, _defineProperty2.default)(this, "defaultSecurityConfig", void 0);
    (0, _defineProperty2.default)(this, "defaultHandlerResolutionStrategy", void 0);
    (0, _defineProperty2.default)(this, "handle", async hapiRequest => {
      var _this$options$options, _handler$options, _handler$options$opti, _handler$options$opti2, _response$options$hea, _validation$response, _validation$response$;
      if (this.handlers.size <= 0) {
        return _response.kibanaResponseFactory.custom({
          statusCode: 500,
          body: `No handlers registered for [${this.method}] [${this.path}].`
        });
      }
      const version = this.getVersion(hapiRequest);
      if (!version) {
        return _response.kibanaResponseFactory.badRequest({
          body: `Please specify a version via ${_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER} header. Available versions: ${this.versionsToString()}`
        });
      }
      if ((0, _route_version_utils.hasQueryVersion)(hapiRequest)) {
        if (!this.enableQueryVersion) {
          return _response.kibanaResponseFactory.badRequest({
            body: `Use of query parameter "${_coreHttpCommon.ELASTIC_HTTP_VERSION_QUERY_PARAM}" is not allowed. Please specify the API version using the "${_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER}" header.`
          });
        }
        (0, _route_version_utils.removeQueryVersion)(hapiRequest);
      }
      const invalidVersionMessage = (0, _route_version_utils.isValidRouteVersion)(this.isPublic, version);
      if (invalidVersionMessage) {
        return _response.kibanaResponseFactory.badRequest({
          body: invalidVersionMessage
        });
      }
      const handler = this.handlers.get(version);
      if (!handler) {
        return _response.kibanaResponseFactory.badRequest({
          body: `No version "${version}" available for [${this.method}] [${this.path}]. Available versions are: ${this.versionsToString()}`
        });
      }
      const validation = extractValidationSchemaFromHandler(handler);
      const {
        error,
        ok: kibanaRequest
      } = (0, _route.validateHapiRequest)(hapiRequest, {
        routeInfo: {
          access: this.options.access,
          httpResource: (_this$options$options = this.options.options) === null || _this$options$options === void 0 ? void 0 : _this$options$options.httpResource,
          deprecated: (_handler$options = handler.options) === null || _handler$options === void 0 ? void 0 : (_handler$options$opti = _handler$options.options) === null || _handler$options$opti === void 0 ? void 0 : _handler$options$opti.deprecated
        },
        router: this.router,
        log: this.log,
        routeSchemas: validation !== null && validation !== void 0 && validation.request ? _validator.RouteValidator.from(validation.request) : undefined,
        version
      });
      if (error) {
        return (0, _util.injectVersionHeader)(version, error);
      }
      let response = await handler.fn(kibanaRequest, _response.kibanaResponseFactory);

      // we don't want to overwrite the header value
      if ((_handler$options$opti2 = handler.options.options) !== null && _handler$options$opti2 !== void 0 && _handler$options$opti2.deprecated && !((_response$options$hea = response.options.headers) !== null && _response$options$hea !== void 0 && _response$options$hea.warning)) {
        response = (0, _util.injectResponseHeaders)({
          warning: (0, _get_warning_header_message.getWarningHeaderMessageFromRouteDeprecation)(handler.options.options.deprecated, this.env.packageInfo.version)
        }, response);
      }
      if (this.env.mode.dev && validation !== null && validation !== void 0 && (_validation$response = validation.response) !== null && _validation$response !== void 0 && (_validation$response$ = _validation$response[response.status]) !== null && _validation$response$ !== void 0 && _validation$response$.body) {
        const {
          [response.status]: responseValidation,
          unsafe
        } = validation.response;
        try {
          const validator = _validator.RouteValidator.from({
            body: (0, _util2.unwrapVersionedResponseBodyValidation)(responseValidation.body),
            unsafe: {
              body: unsafe === null || unsafe === void 0 ? void 0 : unsafe.body
            }
          });
          validator.getBody(response.payload, 'response body');
        } catch (e) {
          return _response.kibanaResponseFactory.custom({
            statusCode: 500,
            body: `Failed output validation: ${e.message}`
          });
        }
      }
      return (0, _util.injectVersionHeader)(version, response);
    });
    (0, _defineProperty2.default)(this, "getSecurity", req => {
      var _this$handlers$get$op, _this$handlers$get, _this$defaultSecurity;
      if (!req) {
        return this.defaultSecurityConfig;
      }
      const version = this.getVersion(req);
      const security = (_this$handlers$get$op = (_this$handlers$get = this.handlers.get(version)) === null || _this$handlers$get === void 0 ? void 0 : _this$handlers$get.options.security) !== null && _this$handlers$get$op !== void 0 ? _this$handlers$get$op : this.defaultSecurityConfig;

      // authc can be defined only on the top route level,
      // so we need to merge it with the versioned one which can have different authz per version
      return security ? {
        authz: security.authz,
        authc: (_this$defaultSecurity = this.defaultSecurityConfig) === null || _this$defaultSecurity === void 0 ? void 0 : _this$defaultSecurity.authc
      } : undefined;
    });
    this.router = router;
    this.log = log;
    this.method = method;
    this.path = path;
    const {
      env,
      useVersionResolutionStrategyForInternalPaths,
      defaultHandlerResolutionStrategy,
      ...options
    } = internalOptions;
    this.isPublic = options.access === 'public';
    this.env = env;
    this.defaultHandlerResolutionStrategy = defaultHandlerResolutionStrategy;
    this.useDefaultStrategyForPath = this.isPublic || useVersionResolutionStrategyForInternalPaths.has(path);
    this.enableQueryVersion = options.enableQueryVersion === true;
    this.defaultSecurityConfig = (0, _security_route_config_validator.validRouteSecurity)(options.security, options.options);
    this.options = options;
    this.router.registerRoute({
      path: this.path,
      options: this.getRouteConfigOptions(),
      security: this.getSecurity,
      handler: request => this.handle(request),
      isVersioned: true,
      method: this.method
    });
  }
  getRouteConfigOptions() {
    return {
      access: this.options.access,
      ...this.options.options
    };
  }

  /** This method assumes that one or more versions handlers are registered  */
  getDefaultVersion() {
    return _handler_resolvers.resolvers[this.defaultHandlerResolutionStrategy]([...this.handlers.keys()], this.options.access);
  }
  versionsToString() {
    return this.handlers.size ? '[' + [...this.handlers.keys()].join(', ') + ']' : '<none>';
  }
  getVersion(req) {
    let version;
    const maybeVersion = (0, _route_version_utils.readVersion)(req, this.enableQueryVersion);
    if (!maybeVersion) {
      if (this.useDefaultStrategyForPath) {
        version = this.getDefaultVersion();
      } else if (!this.env.mode.dev && !this.isPublic) {
        // When in production, we default internal routes to v1 to allow
        // gracefully onboarding of un-versioned to versioned routes
        version = '1';
      }
    } else {
      version = maybeVersion;
    }
    return version;
  }
  validateVersion(version) {
    // We do an additional check here while we only have a single allowed public version
    // for all public Kibana HTTP APIs
    if (this.env.mode.dev && this.isPublic) {
      const message = (0, _route_version_utils.isAllowedPublicVersion)(version);
      if (message) {
        throw new Error(message);
      }
    }
    const message = (0, _route_version_utils.isValidRouteVersion)(this.isPublic, version);
    if (message) {
      throw new Error(message);
    }
    if (this.handlers.has(version)) {
      throw new Error(`Version "${version}" handler has already been registered for the route [${this.method.toLowerCase()}] [${this.path}]"`);
    }
  }
  addVersion(options, handler) {
    this.validateVersion(options.version);
    options = (0, _util2.prepareVersionedRouteValidation)(options);
    this.handlers.set(options.version, {
      fn: this.router.enhanceWithContext(handler),
      options
    });
    return this;
  }
  getHandlers() {
    return [...this.handlers.values()];
  }
}
exports.CoreVersionedRoute = CoreVersionedRoute;