"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderExtension = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class HeaderExtension extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "ref", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "unrender", void 0);
  }
  componentDidMount() {
    this.renderExtension();
  }
  componentDidUpdate(prevProps) {
    if (this.props.extension === prevProps.extension) {
      return;
    }
    this.unrenderExtension();
    this.renderExtension();
  }
  componentWillUnmount() {
    this.unrenderExtension();
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: this.ref,
      className: this.props.containerClassName,
      style: {
        display: this.props.display === 'inlineBlock' ? 'inline-block' : undefined
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    });
  }
  renderExtension() {
    if (!this.ref.current) {
      throw new Error('<HeaderExtension /> mounted without ref');
    }
    if (this.props.extension) {
      this.unrender = this.props.extension(this.ref.current);
    }
  }
  unrenderExtension() {
    if (this.unrender) {
      this.unrender();
      this.unrender = undefined;
    }
  }
}
exports.HeaderExtension = HeaderExtension;