"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApiIndex = exports.CreateApiIndexApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createApiIndex = async ({
  indexName,
  language,
  http
}) => {
  const route = '/internal/content_connectors/indices';
  const params = {
    index_name: indexName,
    language
  };
  const result = await (http === null || http === void 0 ? void 0 : http.post(route, {
    body: JSON.stringify(params)
  }));
  return result ? {
    indexName: result.index
  } : undefined;
};
exports.createApiIndex = createApiIndex;
const CreateApiIndexApiLogic = exports.CreateApiIndexApiLogic = (0, _create_api_logic.createApiLogic)(['create_api_index_api_logic'], createApiIndex);