"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutorSubActionPushParamsSchemaSIR = exports.ExecutorParamsSchemaSIR = void 0;
var _zod = require("@kbn/zod");
var _servicenow = require("../../servicenow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Schema for ServiceNow Security Incident Response (SIR)
const ExecutorSubActionPushParamsSchemaSIR = exports.ExecutorSubActionPushParamsSchemaSIR = _zod.z.object({
  incident: _zod.z.object({
    ..._servicenow.CommonAttributes,
    dest_ip: _zod.z.union([_zod.z.string().nullable().default(null), _zod.z.array(_zod.z.string()).nullable().default(null)]).default(null),
    malware_hash: _zod.z.union([_zod.z.string().nullable().default(null), _zod.z.array(_zod.z.string()).nullable().default(null)]).default(null),
    malware_url: _zod.z.union([_zod.z.string().nullable().default(null), _zod.z.array(_zod.z.string()).nullable().default(null)]).default(null),
    source_ip: _zod.z.union([_zod.z.string().nullable().default(null), _zod.z.array(_zod.z.string()).nullable().default(null)]).default(null),
    priority: _zod.z.string().nullable().default(null)
  }).strict(),
  comments: _servicenow.CommentsSchema
}).strict();

// Executor parameters for ServiceNow Security Incident Response (SIR)
const ExecutorParamsSchemaSIR = exports.ExecutorParamsSchemaSIR = _zod.z.discriminatedUnion('subAction', [_zod.z.object({
  subAction: _zod.z.literal('getFields'),
  subActionParams: _servicenow.ExecutorSubActionCommonFieldsParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('getIncident'),
  subActionParams: _servicenow.ExecutorSubActionGetIncidentParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('handshake'),
  subActionParams: _servicenow.ExecutorSubActionHandshakeParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchemaSIR
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('getChoices'),
  subActionParams: _servicenow.ExecutorSubActionGetChoicesParamsSchema
}).strict()]);