"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.microsoft_defender_endpoint';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.msDefenderEndpoint.title', {
  defaultMessage: 'Microsoft Defender for Endpoint'
});
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["TEST_CONNECTOR"] = "testConnector";
  SUB_ACTION["GET_AGENT_DETAILS"] = "getAgentDetails";
  SUB_ACTION["GET_AGENT_LIST"] = "getAgentList";
  SUB_ACTION["ISOLATE_HOST"] = "isolateHost";
  SUB_ACTION["RELEASE_HOST"] = "releaseHost";
  SUB_ACTION["GET_ACTIONS"] = "getActions";
  SUB_ACTION["GET_LIBRARY_FILES"] = "getLibraryFiles";
  SUB_ACTION["RUN_SCRIPT"] = "runScript";
  SUB_ACTION["GET_ACTION_RESULTS"] = "getActionResults";
  SUB_ACTION["CANCEL_ACTION"] = "cancelAction";
  return SUB_ACTION;
}({});