"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.portSchema = exports.emailSchema = exports.SecretsSchema = exports.ParamsSchemaProps = exports.ParamsSchema = exports.ConfigSchema = exports.AttachmentSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PORT_MAX = 256 * 256 - 1;
const portSchema = () => _zod.z.coerce.number().min(1).max(PORT_MAX);
exports.portSchema = portSchema;
const ConfigSchemaProps = {
  service: _zod.z.string().default('other'),
  host: _zod.z.string().nullable().default(null),
  port: portSchema().nullable().default(null),
  secure: _zod.z.boolean().nullable().default(null),
  from: _zod.z.string(),
  hasAuth: _zod.z.boolean().default(true),
  tenantId: _zod.z.string().nullable().default(null),
  clientId: _zod.z.string().nullable().default(null),
  oauthTokenUrl: _zod.z.string().nullable().default(null)
};
const ConfigSchema = exports.ConfigSchema = _zod.z.object(ConfigSchemaProps).strict();
const SecretsSchemaProps = {
  user: _zod.z.string().nullable().default(null),
  password: _zod.z.string().nullable().default(null),
  clientSecret: _zod.z.string().nullable().default(null)
};
const SecretsSchema = exports.SecretsSchema = _zod.z.object(SecretsSchemaProps).strict();
const AttachmentSchemaProps = {
  content: _zod.z.string(),
  contentType: _zod.z.string().optional(),
  filename: _zod.z.string(),
  encoding: _zod.z.string().optional()
};
const AttachmentSchema = exports.AttachmentSchema = _zod.z.object(AttachmentSchemaProps).strict();
const emailSchema = exports.emailSchema = _zod.z.array(_zod.z.string().max(512)).max(100);
const ParamsSchemaProps = exports.ParamsSchemaProps = {
  to: emailSchema.default([]),
  cc: emailSchema.default([]),
  bcc: emailSchema.default([]),
  subject: _zod.z.string(),
  message: _zod.z.string(),
  messageHTML: _zod.z.string().nullable().default(null),
  // kibanaFooterLink isn't inteded for users to set, this is here to be able to programatically
  // provide a more contextual URL in the footer (ex: URL to the alert details page)
  kibanaFooterLink: _zod.z.object({
    path: _zod.z.string().default('/'),
    text: _zod.z.string().default(_constants.defaultFooterText)
  }).strict().default({
    path: '/',
    text: _constants.defaultFooterText
  }),
  attachments: _zod.z.array(AttachmentSchema).optional()
};
const ParamsSchema = exports.ParamsSchema = _zod.z.object(ParamsSchemaProps).strict();