"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommonError = exports.defaultNoDataRenderer = exports.defaultLoadingRenderer = exports.PACKAGE_NOT_INSTALLED_TEST_SUBJECT = exports.LOADING_STATE_TEST_SUBJECT = exports.KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = exports.DEFAULT_NO_DATA_TEST_SUBJECT = exports.CspNoDataPage = exports.CloudPosturePage = exports.CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageNoData = require("@kbn/shared-ux-page-no-data");
var _full_size_centered_page = require("./full_size_centered_page");
var _csp_loading_state = require("./csp_loading_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_posture_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LOADING_STATE_TEST_SUBJECT = exports.LOADING_STATE_TEST_SUBJECT = 'cloud_posture_page_loading';
const ERROR_STATE_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = 'cloud_posture_page_error';
const PACKAGE_NOT_INSTALLED_TEST_SUBJECT = exports.PACKAGE_NOT_INSTALLED_TEST_SUBJECT = 'cloud_posture_page_package_not_installed';
const CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = exports.CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = 'cloud_posture_page_cspm_not_installed';
const KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = exports.KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = 'cloud_posture_page_kspm_not_installed';
const DEFAULT_NO_DATA_TEST_SUBJECT = exports.DEFAULT_NO_DATA_TEST_SUBJECT = 'cloud_posture_page_no_data';
const isCommonError = error => {
  var _body, _body2, _body3;
  if (!(error !== null && error !== void 0 && error.body) || !(error !== null && error !== void 0 && (_body = error.body) !== null && _body !== void 0 && _body.error) || !(error !== null && error !== void 0 && (_body2 = error.body) !== null && _body2 !== void 0 && _body2.message) || !(error !== null && error !== void 0 && (_body3 = error.body) !== null && _body3 !== void 0 && _body3.statusCode)) {
    return false;
  }
  return true;
};
exports.isCommonError = isCommonError;
const CspNoDataPage = ({
  docsLink,
  actionHref,
  actionTitle,
  actionDescription,
  dataTestSubj,
  buttonText
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageNoData.NoDataPage, {
    action: {
      elasticAgent: {
        docsLink,
        href: actionHref,
        buttonIsDisabled: !actionHref,
        title: actionTitle,
        description: actionDescription,
        'data-test-subj': dataTestSubj,
        buttonText
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};
exports.CspNoDataPage = CspNoDataPage;
const defaultLoadingRenderer = () => /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
  "data-test-subj": LOADING_STATE_TEST_SUBJECT,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.cloudPosturePage.loadingDescription",
  defaultMessage: "Loading...",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 5
  }
}));
exports.defaultLoadingRenderer = defaultLoadingRenderer;
const defaultErrorRenderer = error => /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 88,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  color: "danger",
  iconType: "warning",
  "data-test-subj": ERROR_STATE_TEST_SUBJECT,
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.cloudPosturePage.errorRenderer.errorTitle",
    defaultMessage: "We couldn't fetch your cloud security posture data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  })),
  body: isCommonError(error) ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.cloudPosturePage.errorRenderer.errorDescription",
    defaultMessage: "{error} {statusCode}: {body}",
    values: {
      error: error.body.error,
      statusCode: error.body.statusCode,
      body: error.body.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  })) : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 5
  }
}));
const defaultNoDataRenderer = () => /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 121,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxPageNoData.NoDataPage, {
  action: {
    elasticAgent: {
      'data-test-subj': DEFAULT_NO_DATA_TEST_SUBJECT,
      // TODO: Add real docs link once we have it
      docsLink: 'https://www.elastic.co/guide/index.html'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 5
  }
}));
exports.defaultNoDataRenderer = defaultNoDataRenderer;
const CloudPosturePage = ({
  children,
  query,
  loadingRender = defaultLoadingRenderer,
  errorRender = defaultErrorRenderer,
  noDataRenderer = defaultNoDataRenderer
}) => {
  const render = () => {
    if (!query) {
      return children;
    }
    if (query.isError) {
      return errorRender(query.error);
    }
    if (query.isLoading) {
      return loadingRender();
    }
    if (!query.data) {
      return noDataRenderer();
    }
    return children;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render());
};
exports.CloudPosturePage = CloudPosturePage;