"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiMetricService = exports.VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW = exports.VULNERABILITIES_INSIGHT_HOST_DETAILS = exports.VULNERABILITIES_INSIGHT = exports.VULNERABILITIES_FLYOUT_VISITS = exports.UiMetricService = exports.OPEN_FINDINGS_FLYOUT = exports.NAV_TO_FINDINGS_BY_RULE_NAME_FROM_ENTITY_FLYOUT = exports.NAV_TO_FINDINGS_BY_HOST_NAME_FROM_ENTITY_FLYOUT = exports.MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_USER_DETAILS = exports.MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_HOST_DETAILS = exports.MISCONFIGURATION_INSIGHT = exports.KSPM_NAMESPACE_SELECTOR = exports.GROUP_BY_CLICK = exports.GRAPH_PREVIEW = exports.GRAPH_INVESTIGATION = exports.GENERIC_ENTITY_FLYOUT_OPENED = exports.ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW = exports.ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT = exports.ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS = exports.ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS = exports.CSPM_NAMESPACE_SELECTOR = exports.CREATE_DETECTION_RULE_FROM_FLYOUT = exports.CREATE_DETECTION_FROM_TABLE_ROW_ACTION = exports.CHANGE_RULE_STATE = exports.ASSET_INVENTORY_SEARCH_QUERY_PERFORMED = exports.ASSET_INVENTORY_GROUP_BY_SELECTED_FIELD = exports.ASSET_INVENTORY_GROUP_BY_OPENED = exports.ASSET_INVENTORY_FILTER_TYPE_APPLIED = exports.ASSET_INVENTORY_FILTER_ID_APPLIED = exports.ASSET_INVENTORY_FILTER_CRITICALITY_APPLIED = exports.ASSET_INVENTORY_EXPAND_FLYOUT_SUCCESS = exports.ASSET_INVENTORY_EXPAND_FLYOUT_ERROR = exports.ASSET_INVENTORY_CRITICALITY_ASSIGNED_UPLOAD = exports.ASSET_INVENTORY_CRITICALITY_ASSIGNED_MANUAL = exports.ASSET_INVENTORY_CRITICALITY_ASSIGNED_BULK = exports.ASSET_INVENTORY_COLUMN_REMOVED = exports.ASSET_INVENTORY_COLUMN_ADDED = exports.ASSET_INVENTORY_APP_NAME = exports.APP_NAME = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_NAME = exports.APP_NAME = 'cloud-security';
const ASSET_INVENTORY_APP_NAME = exports.ASSET_INVENTORY_APP_NAME = 'asset-inventory';
const MISCONFIGURATION_INSIGHT = exports.MISCONFIGURATION_INSIGHT = 'misconfiguration-insight-v2';
const VULNERABILITIES_INSIGHT = exports.VULNERABILITIES_INSIGHT = 'vulnerabilities-insight-v2';
const MISCONFIGURATION_INSIGHT_HOST_DETAILS = exports.MISCONFIGURATION_INSIGHT_HOST_DETAILS = `${MISCONFIGURATION_INSIGHT}-host-details`;
const MISCONFIGURATION_INSIGHT_USER_DETAILS = exports.MISCONFIGURATION_INSIGHT_USER_DETAILS = `${MISCONFIGURATION_INSIGHT}-user-details`;
const MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW = `${MISCONFIGURATION_INSIGHT}-host-entity-overview`;
const MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW = `${MISCONFIGURATION_INSIGHT}-user-entity-overview`;
const VULNERABILITIES_INSIGHT_HOST_DETAILS = exports.VULNERABILITIES_INSIGHT_HOST_DETAILS = `${VULNERABILITIES_INSIGHT}-host-details`;
const VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW = exports.VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW = `${VULNERABILITIES_INSIGHT}-host-entity-overview`;
const ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT = exports.ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT = 'entity-flyout-with-misconfiguration-visits';
const ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW = exports.ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW = 'entity-flyout-with-vulnerability-preview-visits';
const ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS = exports.ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS = 'entity-flyout-expand-misconfiguration-view-visits';
const ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS = exports.ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS = 'entity-flyout-expand-vulnerability-view-visits';
const NAV_TO_FINDINGS_BY_HOST_NAME_FROM_ENTITY_FLYOUT = exports.NAV_TO_FINDINGS_BY_HOST_NAME_FROM_ENTITY_FLYOUT = 'nav-to-findings-by-host-name-from-entity-flyout';
const NAV_TO_FINDINGS_BY_RULE_NAME_FROM_ENTITY_FLYOUT = exports.NAV_TO_FINDINGS_BY_RULE_NAME_FROM_ENTITY_FLYOUT = 'nav-to-findings-by-rule-name-from-entity-flyout';
const CREATE_DETECTION_RULE_FROM_FLYOUT = exports.CREATE_DETECTION_RULE_FROM_FLYOUT = 'create-detection-rule-from-flyout';
const CREATE_DETECTION_FROM_TABLE_ROW_ACTION = exports.CREATE_DETECTION_FROM_TABLE_ROW_ACTION = 'create-detection-from-table-row-action';
const VULNERABILITIES_FLYOUT_VISITS = exports.VULNERABILITIES_FLYOUT_VISITS = 'vulnerabilities-flyout-visits';
const OPEN_FINDINGS_FLYOUT = exports.OPEN_FINDINGS_FLYOUT = 'open-findings-flyout';
const GROUP_BY_CLICK = exports.GROUP_BY_CLICK = 'group-by-click';
const CHANGE_RULE_STATE = exports.CHANGE_RULE_STATE = 'change-rule-state';
const GRAPH_PREVIEW = exports.GRAPH_PREVIEW = 'graph-preview';
const GRAPH_INVESTIGATION = exports.GRAPH_INVESTIGATION = 'graph-investigation';
const ASSET_INVENTORY_EXPAND_FLYOUT_SUCCESS = exports.ASSET_INVENTORY_EXPAND_FLYOUT_SUCCESS = 'asset-inventory-expand-flyout-success';
const ASSET_INVENTORY_EXPAND_FLYOUT_ERROR = exports.ASSET_INVENTORY_EXPAND_FLYOUT_ERROR = 'asset-inventory-expand-flyout-error';
const GENERIC_ENTITY_FLYOUT_OPENED = exports.GENERIC_ENTITY_FLYOUT_OPENED = 'generic-entity-flyout-opened';
const KSPM_NAMESPACE_SELECTOR = exports.KSPM_NAMESPACE_SELECTOR = 'kspm-dashboard-namespace-selector-dropdown';
const CSPM_NAMESPACE_SELECTOR = exports.CSPM_NAMESPACE_SELECTOR = 'cspm-dashboard-namespace-selector-dropdown';
const ASSET_INVENTORY_FILTER_CRITICALITY_APPLIED = exports.ASSET_INVENTORY_FILTER_CRITICALITY_APPLIED = 'filter_criticality_applied';
const ASSET_INVENTORY_FILTER_TYPE_APPLIED = exports.ASSET_INVENTORY_FILTER_TYPE_APPLIED = 'filter_type_applied';
const ASSET_INVENTORY_FILTER_ID_APPLIED = exports.ASSET_INVENTORY_FILTER_ID_APPLIED = 'filter_id_applied';
const ASSET_INVENTORY_SEARCH_QUERY_PERFORMED = exports.ASSET_INVENTORY_SEARCH_QUERY_PERFORMED = 'search_query_performed';
const ASSET_INVENTORY_COLUMN_ADDED = exports.ASSET_INVENTORY_COLUMN_ADDED = 'column_added';
const ASSET_INVENTORY_COLUMN_REMOVED = exports.ASSET_INVENTORY_COLUMN_REMOVED = 'column_removed';
const ASSET_INVENTORY_GROUP_BY_OPENED = exports.ASSET_INVENTORY_GROUP_BY_OPENED = 'group_by_opened';
const ASSET_INVENTORY_GROUP_BY_SELECTED_FIELD = exports.ASSET_INVENTORY_GROUP_BY_SELECTED_FIELD = 'group_by_selected_field_';
const ASSET_INVENTORY_CRITICALITY_ASSIGNED_MANUAL = exports.ASSET_INVENTORY_CRITICALITY_ASSIGNED_MANUAL = 'criticality_assigned_manual';
const ASSET_INVENTORY_CRITICALITY_ASSIGNED_BULK = exports.ASSET_INVENTORY_CRITICALITY_ASSIGNED_BULK = 'criticality_assigned_bulk';
const ASSET_INVENTORY_CRITICALITY_ASSIGNED_UPLOAD = exports.ASSET_INVENTORY_CRITICALITY_ASSIGNED_UPLOAD = 'criticality_assigned_upload';
class UiMetricService {
  constructor() {
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
  }
  setup(usageCollection) {
    this.usageCollection = usageCollection;
  }
  track(metricType, eventName, appName = APP_NAME) {
    if (!this.usageCollection) {
      // Usage collection might be disabled in Kibana config.
      return;
    }
    return this.usageCollection.reportUiCounter(appName, metricType, eventName);
  }
  trackUiMetric(metricType, eventName, appName) {
    return this.track(metricType, eventName, appName);
  }
}
exports.UiMetricService = UiMetricService;
const uiMetricService = exports.uiMetricService = new UiMetricService();