"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVulnerabilitiesQuery = exports.getVulnerabilitiesAggregationCount = exports.getMisconfigurationAggregationCount = exports.getFindingsCountAggQueryVulnerabilities = exports.getFindingsCountAggQueryMisconfiguration = exports.createMisconfigurationFindingsQuery = exports.createGetVulnerabilityFindingsQuery = exports.buildVulnerabilityFindingsQueryWithFilters = exports.buildMisconfigurationsFindingsQuery = exports.buildFindingsQueryWithFilters = exports.VULNERABILITIES_RESULT_EVALUATION = void 0;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MISCONFIGURATIONS_SOURCE_FIELDS = ['result.*', 'rule.*', 'resource.*'];
const RESULT_EVALUATION = {
  PASSED: 'passed',
  FAILED: 'failed',
  UNKNOWN: 'unknown'
};
const VULNERABILITIES_RESULT_EVALUATION = exports.VULNERABILITIES_RESULT_EVALUATION = {
  LOW: 'LOW',
  MEDIUM: 'MEDIUM',
  HIGH: 'HIGH',
  CRITICAL: 'CRITICAL',
  NONE: 'NONE'
};
const getFindingsCountAggQueryMisconfiguration = () => ({
  count: {
    filters: {
      other_bucket_key: RESULT_EVALUATION.UNKNOWN,
      filters: {
        [RESULT_EVALUATION.PASSED]: {
          match: {
            'result.evaluation': RESULT_EVALUATION.PASSED
          }
        },
        [RESULT_EVALUATION.FAILED]: {
          match: {
            'result.evaluation': RESULT_EVALUATION.FAILED
          }
        }
      }
    }
  }
});
exports.getFindingsCountAggQueryMisconfiguration = getFindingsCountAggQueryMisconfiguration;
const getMisconfigurationAggregationCount = buckets => {
  const defaultBuckets = {
    [RESULT_EVALUATION.PASSED]: {
      doc_count: 0
    },
    [RESULT_EVALUATION.FAILED]: {
      doc_count: 0
    },
    [RESULT_EVALUATION.UNKNOWN]: {
      doc_count: 0
    }
  };

  // if buckets are undefined we will use default buckets
  const usedBuckets = buckets || defaultBuckets;
  return Object.entries(usedBuckets).reduce((evaluation, [key, value]) => {
    evaluation[key] = (evaluation[key] || 0) + (value.doc_count || 0);
    return evaluation;
  }, {
    [RESULT_EVALUATION.PASSED]: 0,
    [RESULT_EVALUATION.FAILED]: 0,
    [RESULT_EVALUATION.UNKNOWN]: 0
  });
};
exports.getMisconfigurationAggregationCount = getMisconfigurationAggregationCount;
const buildMisconfigurationsFindingsQuery = ({
  query,
  sort
}, rulesStates, isPreview = false) => {
  const mutedRulesFilterQuery = (0, _.buildMutedRulesFilter)(rulesStates);
  return {
    index: _.CDR_MISCONFIGURATIONS_INDEX_PATTERN,
    size: isPreview ? 0 : 500,
    aggs: getFindingsCountAggQueryMisconfiguration(),
    ignore_unavailable: true,
    query: buildMisconfigurationsFindingsQueryWithFilters(query, mutedRulesFilterQuery),
    _source: MISCONFIGURATIONS_SOURCE_FIELDS,
    sort
  };
};
exports.buildMisconfigurationsFindingsQuery = buildMisconfigurationsFindingsQuery;
const buildMisconfigurationsFindingsQueryWithFilters = (query, mutedRulesFilterQuery) => {
  var _query$bool$filter, _query$bool;
  return {
    ...query,
    bool: {
      ...(query === null || query === void 0 ? void 0 : query.bool),
      filter: [...((_query$bool$filter = query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) !== null && _query$bool$filter !== void 0 ? _query$bool$filter : []), {
        range: {
          '@timestamp': {
            gte: `now-${_.LATEST_FINDINGS_RETENTION_POLICY}`,
            lte: 'now'
          }
        }
      }],
      must_not: [...mutedRulesFilterQuery]
    }
  };
};
const getVulnerabilitiesAggregationCount = buckets => {
  const defaultBuckets = {
    [VULNERABILITIES_RESULT_EVALUATION.LOW]: {
      doc_count: 0
    },
    [VULNERABILITIES_RESULT_EVALUATION.MEDIUM]: {
      doc_count: 0
    },
    [VULNERABILITIES_RESULT_EVALUATION.HIGH]: {
      doc_count: 0
    },
    [VULNERABILITIES_RESULT_EVALUATION.CRITICAL]: {
      doc_count: 0
    },
    [VULNERABILITIES_RESULT_EVALUATION.NONE]: {
      doc_count: 0
    }
  };

  // if buckets are undefined we will use default buckets
  const usedBuckets = buckets || defaultBuckets;
  return Object.entries(usedBuckets).reduce((evaluation, [key, value]) => {
    evaluation[key] = (evaluation[key] || 0) + (value.doc_count || 0);
    return evaluation;
  }, {
    [VULNERABILITIES_RESULT_EVALUATION.LOW]: 0,
    [VULNERABILITIES_RESULT_EVALUATION.MEDIUM]: 0,
    [VULNERABILITIES_RESULT_EVALUATION.HIGH]: 0,
    [VULNERABILITIES_RESULT_EVALUATION.CRITICAL]: 0,
    [VULNERABILITIES_RESULT_EVALUATION.NONE]: 0
  });
};
exports.getVulnerabilitiesAggregationCount = getVulnerabilitiesAggregationCount;
const getFindingsCountAggQueryVulnerabilities = () => ({
  count: {
    filters: {
      other_bucket_key: VULNERABILITIES_RESULT_EVALUATION.NONE,
      filters: {
        [VULNERABILITIES_RESULT_EVALUATION.LOW]: {
          term: {
            'vulnerability.severity': {
              value: VULNERABILITIES_RESULT_EVALUATION.LOW,
              case_insensitive: true
            }
          }
        },
        [VULNERABILITIES_RESULT_EVALUATION.MEDIUM]: {
          term: {
            'vulnerability.severity': {
              value: VULNERABILITIES_RESULT_EVALUATION.MEDIUM,
              case_insensitive: true
            }
          }
        },
        [VULNERABILITIES_RESULT_EVALUATION.HIGH]: {
          term: {
            'vulnerability.severity': {
              value: VULNERABILITIES_RESULT_EVALUATION.HIGH,
              case_insensitive: true
            }
          }
        },
        [VULNERABILITIES_RESULT_EVALUATION.CRITICAL]: {
          term: {
            'vulnerability.severity': {
              value: VULNERABILITIES_RESULT_EVALUATION.CRITICAL,
              case_insensitive: true
            }
          }
        }
      }
    }
  }
});
exports.getFindingsCountAggQueryVulnerabilities = getFindingsCountAggQueryVulnerabilities;
const getVulnerabilitiesQuery = ({
  query,
  sort
}, isPreview = false) => ({
  index: _.CDR_VULNERABILITIES_INDEX_PATTERN,
  size: isPreview ? 0 : 500,
  aggs: getFindingsCountAggQueryVulnerabilities(),
  ignore_unavailable: true,
  query: buildVulnerabilityFindingsQueryWithFilters(query),
  sort
});
exports.getVulnerabilitiesQuery = getVulnerabilitiesQuery;
const buildVulnerabilityFindingsQueryWithFilters = query => {
  var _query$bool$filter2, _query$bool2;
  return {
    ...query,
    bool: {
      ...(query === null || query === void 0 ? void 0 : query.bool),
      filter: [...((_query$bool$filter2 = query === null || query === void 0 ? void 0 : (_query$bool2 = query.bool) === null || _query$bool2 === void 0 ? void 0 : _query$bool2.filter) !== null && _query$bool$filter2 !== void 0 ? _query$bool$filter2 : []), {
        range: {
          '@timestamp': {
            gte: `now-${_.CDR_EXTENDED_VULN_RETENTION_POLICY}`,
            lte: 'now'
          }
        }
      }]
    }
  };
};
exports.buildVulnerabilityFindingsQueryWithFilters = buildVulnerabilityFindingsQueryWithFilters;
const buildFindingsQueryWithFilters = query => {
  var _query$bool$filter3, _query$bool3;
  return {
    ...query,
    bool: {
      ...(query === null || query === void 0 ? void 0 : query.bool),
      filter: [...((_query$bool$filter3 = query === null || query === void 0 ? void 0 : (_query$bool3 = query.bool) === null || _query$bool3 === void 0 ? void 0 : _query$bool3.filter) !== null && _query$bool$filter3 !== void 0 ? _query$bool$filter3 : [])]
    }
  };
};
exports.buildFindingsQueryWithFilters = buildFindingsQueryWithFilters;
const createMisconfigurationFindingsQuery = (resourceId, ruleId) => {
  return {
    bool: {
      filter: [{
        term: {
          'rule.id': ruleId
        }
      }, {
        term: {
          'resource.id': resourceId
        }
      }]
    }
  };
};

/* 
The event.id is important in this query because removing it can lead to unintended results—specifically, 
if vulnerabilityId = ['a'], the query may return documents where vulnerabilityId is ['a'], ['a', 'b'], and so on. 
This happens because the check only verifies if the value exists within the combined string representation.
*/
exports.createMisconfigurationFindingsQuery = createMisconfigurationFindingsQuery;
const createGetVulnerabilityFindingsQuery = (vulnerabilityId, resourceId, packageName, packageVersion, eventId) => {
  const filters = [];
  const mustNotFilters = [];
  const addTermFilter = (field, value) => {
    if (value !== undefined) {
      filters.push({
        terms: {
          [field]: Array.isArray(value) ? value : [value]
        }
      });
    } else {
      mustNotFilters.push({
        exists: {
          field
        }
      });
    }
  };
  addTermFilter('vulnerability.id', vulnerabilityId);
  addTermFilter('resource.id', resourceId);
  addTermFilter('package.name', packageName);
  addTermFilter('package.version', packageVersion);
  addTermFilter('event.id', eventId);
  return {
    bool: {
      filter: filters,
      must_not: mustNotFilters
    }
  };
};
exports.createGetVulnerabilityFindingsQuery = createGetVulnerabilityFindingsQuery;