"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectTelemetryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _client = require("./client");
var _events = require("./events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudConnectTelemetryService {
  constructor() {
    (0, _defineProperty2.default)(this, "analytics", void 0);
  }
  setup(analytics) {
    this.analytics = analytics;

    // Register all event types
    this.analytics.registerEventType(_events.clusterConnectedEventType);
    this.analytics.registerEventType(_events.clusterDisconnectedEventType);
    this.analytics.registerEventType(_events.serviceEnabledEventType);
    this.analytics.registerEventType(_events.serviceDisabledEventType);
    this.analytics.registerEventType(_events.linkClickedEventType);
  }
  getClient() {
    if (!this.analytics) {
      throw new Error('Analytics service is not available.');
    }
    return new _client.CloudConnectTelemetryService(this.analytics);
  }
}
exports.CloudConnectTelemetryService = CloudConnectTelemetryService;