"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEarliestCase = void 0;
var _use_get_cases = require("../../containers/use_get_cases");
var _types = require("../../../common/ui/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the earliest case from the cases list for the given owner.
 */
const useGetEarliestCase = filterOptions => {
  var _data$cases;
  const {
    data,
    isLoading
  } = (0, _use_get_cases.useGetCases)({
    filterOptions: {
      owner: filterOptions.owner,
      from: undefined,
      to: undefined
    },
    queryParams: {
      page: 1,
      perPage: 1,
      sortField: _types.SortFieldCase.createdAt,
      sortOrder: 'asc'
    }
  });
  return {
    earliestCase: data === null || data === void 0 ? void 0 : (_data$cases = data.cases) === null || _data$cases === void 0 ? void 0 : _data$cases[0],
    isLoading
  };
};
exports.useGetEarliestCase = useGetEarliestCase;