"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserCommentAttachmentRt = exports.UserCommentAttachmentPayloadRt = exports.SingleFileAttachmentMetadataRt = exports.PersistableStateAttachmentRt = exports.PersistableStateAttachmentPayloadRt = exports.IsolateHostActionType = exports.FileAttachmentMetadataRt = exports.FileAttachmentMetadataPayloadRt = exports.ExternalReferenceWithoutRefsAttachmentPayloadRt = exports.ExternalReferenceStorageType = exports.ExternalReferenceSOWithoutRefsAttachmentPayloadRt = exports.ExternalReferenceSOAttachmentPayloadRt = exports.ExternalReferenceNoSOAttachmentPayloadRt = exports.ExternalReferenceAttachmentRt = exports.ExternalReferenceAttachmentPayloadRt = exports.EventAttachmentRt = exports.EventAttachmentPayloadRt = exports.EventAttachmentAttributesRt = exports.DocumentAttachmentAttributesRt = exports.AttachmentsRt = exports.AttachmentType = exports.AttachmentRt = exports.AttachmentPayloadRt = exports.AttachmentPatchAttributesRt = exports.AttachmentAttributesRt = exports.AttachmentAttributesBasicRt = exports.AlertAttachmentRt = exports.AlertAttachmentPayloadRt = exports.AlertAttachmentAttributesRt = exports.ActionsAttachmentRt = exports.ActionsAttachmentPayloadRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _schema = require("../../../schema");
var _api = require("../../../api");
var _v = require("../user/v1");
var _constants = require("../../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Files
 */
const SingleFileAttachmentMetadataRt = exports.SingleFileAttachmentMetadataRt = rt.strict({
  name: rt.string,
  extension: rt.string,
  mimeType: rt.string,
  created: rt.string
});
const FileAttachmentMetadataRt = exports.FileAttachmentMetadataRt = rt.strict({
  files: rt.array(SingleFileAttachmentMetadataRt)
});
const AttachmentAttributesBasicRt = exports.AttachmentAttributesBasicRt = rt.strict({
  created_at: rt.string,
  created_by: _v.UserRt,
  owner: rt.string,
  pushed_at: rt.union([rt.string, rt.null]),
  pushed_by: rt.union([_v.UserRt, rt.null]),
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_v.UserRt, rt.null])
});
const FileAttachmentMetadataPayloadRt = exports.FileAttachmentMetadataPayloadRt = rt.strict({
  mimeType: _schema.mimeTypeString,
  filename: (0, _schema.limitedStringSchema)({
    fieldName: 'filename',
    min: 1,
    max: _constants.MAX_FILENAME_LENGTH
  })
});

/**
 * User comment
 */
let AttachmentType = exports.AttachmentType = /*#__PURE__*/function (AttachmentType) {
  AttachmentType["actions"] = "actions";
  AttachmentType["alert"] = "alert";
  AttachmentType["event"] = "event";
  AttachmentType["externalReference"] = "externalReference";
  AttachmentType["persistableState"] = "persistableState";
  AttachmentType["user"] = "user";
  return AttachmentType;
}({});
const UserCommentAttachmentPayloadRt = exports.UserCommentAttachmentPayloadRt = rt.strict({
  comment: rt.string,
  type: rt.literal(AttachmentType.user),
  owner: rt.string
});
const UserCommentAttachmentAttributesRt = rt.intersection([UserCommentAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const UserCommentAttachmentRt = exports.UserCommentAttachmentRt = rt.intersection([UserCommentAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
/**
 * Generic event
 */

const EventAttachmentPayloadRt = exports.EventAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.event),
  eventId: rt.union([rt.array(rt.string), rt.string]),
  index: rt.union([rt.array(rt.string), rt.string]),
  owner: rt.string
});

/**
 * Alerts
 */

const AlertAttachmentPayloadRt = exports.AlertAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.alert),
  alertId: rt.union([rt.array(rt.string), rt.string]),
  index: rt.union([rt.array(rt.string), rt.string]),
  rule: rt.strict({
    id: rt.union([rt.string, rt.null]),
    name: rt.union([rt.string, rt.null])
  }),
  owner: rt.string
});
const AlertAttachmentAttributesRt = exports.AlertAttachmentAttributesRt = rt.intersection([AlertAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const EventAttachmentAttributesRt = exports.EventAttachmentAttributesRt = rt.intersection([EventAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const AlertAttachmentRt = exports.AlertAttachmentRt = rt.intersection([AlertAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
const EventAttachmentRt = exports.EventAttachmentRt = rt.intersection([EventAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
const DocumentAttachmentAttributesRt = exports.DocumentAttachmentAttributesRt = rt.union([AlertAttachmentAttributesRt, EventAttachmentAttributesRt]);
/**
 * Actions
 */
let IsolateHostActionType = exports.IsolateHostActionType = /*#__PURE__*/function (IsolateHostActionType) {
  IsolateHostActionType["isolate"] = "isolate";
  IsolateHostActionType["unisolate"] = "unisolate";
  return IsolateHostActionType;
}({});
const ActionsAttachmentPayloadRt = exports.ActionsAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.actions),
  comment: rt.string,
  actions: rt.strict({
    targets: rt.array(rt.strict({
      hostname: rt.string,
      endpointId: rt.string
    })),
    type: rt.string
  }),
  owner: rt.string
});
const ActionsAttachmentAttributesRt = rt.intersection([ActionsAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ActionsAttachmentRt = exports.ActionsAttachmentRt = rt.intersection([ActionsAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
/**
 * External reference
 */
let ExternalReferenceStorageType = exports.ExternalReferenceStorageType = /*#__PURE__*/function (ExternalReferenceStorageType) {
  ExternalReferenceStorageType["savedObject"] = "savedObject";
  ExternalReferenceStorageType["elasticSearchDoc"] = "elasticSearchDoc";
  return ExternalReferenceStorageType;
}({});
const ExternalReferenceStorageNoSORt = rt.strict({
  type: rt.literal(ExternalReferenceStorageType.elasticSearchDoc)
});
const ExternalReferenceStorageSORt = rt.strict({
  type: rt.literal(ExternalReferenceStorageType.savedObject),
  soType: rt.string
});
const ExternalReferenceBaseAttachmentPayloadRt = rt.strict({
  externalReferenceAttachmentTypeId: rt.string,
  externalReferenceMetadata: rt.union([rt.null, rt.record(rt.string, _api.jsonValueRt)]),
  type: rt.literal(AttachmentType.externalReference),
  owner: rt.string
});
const ExternalReferenceNoSOAttachmentPayloadRt = exports.ExternalReferenceNoSOAttachmentPayloadRt = rt.strict({
  ...ExternalReferenceBaseAttachmentPayloadRt.type.props,
  externalReferenceId: rt.string,
  externalReferenceStorage: ExternalReferenceStorageNoSORt
});
const ExternalReferenceSOAttachmentPayloadRt = exports.ExternalReferenceSOAttachmentPayloadRt = rt.strict({
  ...ExternalReferenceBaseAttachmentPayloadRt.type.props,
  externalReferenceId: rt.string,
  externalReferenceStorage: ExternalReferenceStorageSORt
});

// externalReferenceId is missing.
const ExternalReferenceSOWithoutRefsAttachmentPayloadRt = exports.ExternalReferenceSOWithoutRefsAttachmentPayloadRt = rt.strict({
  ...ExternalReferenceBaseAttachmentPayloadRt.type.props,
  externalReferenceStorage: ExternalReferenceStorageSORt
});
const ExternalReferenceAttachmentPayloadRt = exports.ExternalReferenceAttachmentPayloadRt = rt.union([ExternalReferenceNoSOAttachmentPayloadRt, ExternalReferenceSOAttachmentPayloadRt]);
const ExternalReferenceWithoutRefsAttachmentPayloadRt = exports.ExternalReferenceWithoutRefsAttachmentPayloadRt = rt.union([ExternalReferenceNoSOAttachmentPayloadRt, ExternalReferenceSOWithoutRefsAttachmentPayloadRt]);
const ExternalReferenceAttachmentAttributesRt = rt.intersection([ExternalReferenceAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceWithoutRefsAttachmentAttributesRt = rt.intersection([ExternalReferenceWithoutRefsAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceNoSOAttachmentAttributesRt = rt.intersection([ExternalReferenceNoSOAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceSOAttachmentAttributesRt = rt.intersection([ExternalReferenceSOAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceAttachmentRt = exports.ExternalReferenceAttachmentRt = rt.intersection([ExternalReferenceAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
/**
 * Persistable state
 */

const PersistableStateAttachmentPayloadRt = exports.PersistableStateAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.persistableState),
  owner: rt.string,
  persistableStateAttachmentTypeId: rt.string,
  persistableStateAttachmentState: rt.record(rt.string, _api.jsonValueRt)
});
const PersistableStateAttachmentAttributesRt = rt.intersection([PersistableStateAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const PersistableStateAttachmentRt = exports.PersistableStateAttachmentRt = rt.intersection([PersistableStateAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
/**
 * Common
 */

const AttachmentPayloadRt = exports.AttachmentPayloadRt = rt.union([UserCommentAttachmentPayloadRt, AlertAttachmentPayloadRt, EventAttachmentPayloadRt, ActionsAttachmentPayloadRt, ExternalReferenceNoSOAttachmentPayloadRt, ExternalReferenceSOAttachmentPayloadRt, PersistableStateAttachmentPayloadRt]);
const AttachmentAttributesRt = exports.AttachmentAttributesRt = rt.union([UserCommentAttachmentAttributesRt, AlertAttachmentAttributesRt, EventAttachmentAttributesRt, ActionsAttachmentAttributesRt, ExternalReferenceAttachmentAttributesRt, PersistableStateAttachmentAttributesRt]);
const AttachmentAttributesNoSORt = rt.union([UserCommentAttachmentAttributesRt, AlertAttachmentAttributesRt, EventAttachmentAttributesRt, ActionsAttachmentAttributesRt, ExternalReferenceNoSOAttachmentAttributesRt, PersistableStateAttachmentAttributesRt]);
const AttachmentAttributesWithoutRefsRt = rt.union([UserCommentAttachmentAttributesRt, AlertAttachmentAttributesRt, EventAttachmentAttributesRt, ActionsAttachmentAttributesRt, ExternalReferenceWithoutRefsAttachmentAttributesRt, PersistableStateAttachmentAttributesRt]);
const AttachmentRt = exports.AttachmentRt = rt.intersection([AttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
const AttachmentsRt = exports.AttachmentsRt = rt.array(AttachmentRt);

/**
 * This type is used by the CaseService.
 * Because the type for the attributes of savedObjectClient update function is Partial<T>
 * we need to make all of our attributes partial too.
 * We ensure that partial updates of CommentContext is not going to happen inside the patch comment route.
 */
const AttachmentPatchAttributesRt = exports.AttachmentPatchAttributesRt = rt.intersection([rt.union([rt.exact(rt.partial(UserCommentAttachmentPayloadRt.type.props)), rt.exact(rt.partial(AlertAttachmentPayloadRt.type.props)), rt.exact(rt.partial(EventAttachmentPayloadRt.type.props)), rt.exact(rt.partial(ActionsAttachmentPayloadRt.type.props)), rt.exact(rt.partial(ExternalReferenceNoSOAttachmentPayloadRt.type.props)), rt.exact(rt.partial(ExternalReferenceSOAttachmentPayloadRt.type.props)), rt.exact(rt.partial(PersistableStateAttachmentPayloadRt.type.props))]), rt.exact(rt.partial(AttachmentAttributesBasicRt.type.props))]);