"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportedWorkpad = exports.getDefaultWorkpad = exports.getDefaultSidebar = exports.getDefaultPage = exports.getDefaultFlyouts = exports.getDefaultElement = void 0;
var _get_id = require("../lib/get_id");
var _constants = require("../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultElement = () => {
  return {
    id: (0, _get_id.getId)('element'),
    position: {
      top: 20,
      left: 20,
      height: 300,
      width: 500,
      angle: 0,
      type: 'element'
    },
    expression: `
      demodata
      | pointseries y="median(cost)" x=time color="project"
      | plot defaultStyle={seriesStyle points=5}
    `,
    filter: null
  };
};
exports.getDefaultElement = getDefaultElement;
const getDefaultPage = () => {
  return {
    id: (0, _get_id.getId)('page'),
    style: {
      background: '#FFF'
    },
    transition: {},
    elements: [],
    groups: []
  };
};
exports.getDefaultPage = getDefaultPage;
const getDefaultWorkpad = () => {
  const page = getDefaultPage();
  return {
    name: 'My Canvas Workpad',
    id: (0, _get_id.getId)('workpad'),
    width: 1080,
    height: 720,
    css: _constants.DEFAULT_WORKPAD_CSS,
    page: 0,
    pages: [page],
    colors: ['#37988d', '#c19628', '#b83c6f', '#3f9939', '#1785b0', '#ca5f35', '#45bdb0', '#f2bc33', '#e74b8b', '#4fbf48', '#1ea6dc', '#fd7643', '#72cec3', '#f5cc5d', '#ec77a8', '#7acf74', '#4cbce4', '#fd986f', '#a1ded7', '#f8dd91', '#f2a4c5', '#a6dfa2', '#86d2ed', '#fdba9f', '#000000', '#444444', '#777777', '#BBBBBB', '#FFFFFF', 'rgba(255,255,255,0)' // 'transparent'
    ],
    variables: [],
    isWriteable: true
  };
};
exports.getDefaultWorkpad = getDefaultWorkpad;
const getExportedWorkpad = () => {
  const workpad = getDefaultWorkpad();
  return {
    id: workpad.id,
    attributes: workpad
  };
};
exports.getExportedWorkpad = getExportedWorkpad;
const getDefaultSidebar = () => ({
  groupFiltersByOption: _constants.DEFAULT_GROUP_BY_FIELD
});
exports.getDefaultSidebar = getDefaultSidebar;
const getDefaultFlyouts = () => ({
  keyboardShortcutsDoc: {
    isVisible: false
  }
});
exports.getDefaultFlyouts = getDefaultFlyouts;