"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.init = init;
exports.reportUiCounter = void 0;
exports.trackCanvasUiMetric = trackCanvasUiMetric;
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let reportUiCounter = exports.reportUiCounter = void 0;
function init(_reportUiCounter) {
  exports.reportUiCounter = reportUiCounter = _reportUiCounter;
}
function trackCanvasUiMetric(metricType, name) {
  if (!reportUiCounter) {
    return;
  }
  reportUiCounter('canvas', metricType, name);
}