"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _filter = require("../../lib/filter");
var _sidebar = require("../../state/actions/sidebar");
var _sidebar2 = require("../../state/selectors/sidebar");
var _hooks = require("./hooks");
var _workpad_filters = require("./workpad_filters.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_filters/workpad_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadFilters = ({
  element
}) => {
  const groupFiltersByField = (0, _reactRedux.useSelector)(state => (0, _sidebar2.getGroupFiltersByOption)(state));
  const dispatch = (0, _reactRedux.useDispatch)();
  const onGroupByChange = (0, _react.useCallback)(groupByOption => {
    dispatch((0, _sidebar.setGroupFiltersByOption)(groupByOption));
  }, [dispatch]);
  const filterExprs = element ? (0, _filter.getFiltersExprsFromExpression)(element.expression) : [];
  const canvasFilters = (0, _hooks.useCanvasFilters)(filterExprs);
  const filtersGroups = groupFiltersByField ? (0, _filter.groupFiltersBy)(canvasFilters, groupFiltersByField) : [];
  return /*#__PURE__*/_react.default.createElement(_workpad_filters.WorkpadFilters, {
    filtersGroups: filtersGroups,
    onGroupByChange: onGroupByChange,
    groupFiltersByField: groupFiltersByField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.WorkpadFilters = WorkpadFilters;