"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapePickerPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _popover = require("../popover");
var _shape_picker = require("../shape_picker");
var _shape_preview = require("../shape_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/shape_picker_popover/shape_picker_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShapePickerPopover = ({
  shapes,
  onChange,
  value,
  ariaLabel
}) => {
  const button = handleClick => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": ariaLabel,
    style: {
      fontSize: 0
    },
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shape_preview.ShapePreview, {
    shape: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    panelClassName: "canvas",
    button: button,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, () => /*#__PURE__*/_react.default.createElement(_shape_picker.ShapePicker, {
    onChange: onChange,
    shapes: shapes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 14
    }
  }));
};
exports.ShapePickerPopover = ShapePickerPopover;
ShapePickerPopover.propTypes = {
  ariaLabel: _propTypes.default.string,
  onChange: _propTypes.default.func,
  // @ts-expect-error upgrade typescript v5.9.3
  shapes: _propTypes.default.object.isRequired,
  // @ts-expect-error upgrade typescript v5.9.3
  value: _propTypes.default.string
};